package ru.nilsoft.example;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.TextView;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMError;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMLibHandler;

/**
 * Сборка фискального документа произвольного вида.
 *
 * Фискальный документ произвольного вида состоит из:
 * - обязательных полей;
 * - дополнительных полей.
 *
 * Чек должен содержать определенный состав тегов (зависит от типа документа).
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class ReceiptFreeActivity extends AppCompatActivity implements MessageBox.CallBack{
    /** Название файла для сохранения данных чека. */
    private final static String RECEIPT_NAME = "receiptfree.xml";
    /** Handler для работы c контроллером ФН. */
    private Handler h;
    /** Выход из активности. */
    private boolean isExit = false;

    /** Описатель параметров чека. */
    public static class Param{
        public byte flipFOffs;
        public byte pageNum;
        public byte hCopyNum;
        public byte vCopyNum;
        public short LOffs;
        public short VGap;
        public byte LGap;
    }

    /** Параметры чека. */
    private static final Param param = new Param();

    /** Описатель параметров чека. */
    public static class PosField{
        short line;
        short col;
        byte font;

        PosField(short line, short col, byte font) {
            this.line = line;
            this.col = col;
            this.font = font;
        }
    }

    /** Обязательные позиции чека. */
    private static final List<PosField> posFields = new ArrayList<>(7);

    /** Класс описывающий свободные позиции. */
    public static class FreeFieldItem {
        short line;
        short col;
        byte font;
        byte printMode;
        byte jourNum;
        String tInfo;

        FreeFieldItem(short line, short col, byte font, byte printMode, byte jourNum, String tInfo){
            this.line = line;
            this.col = col;
            this.font = font;
            this.printMode = printMode;
            this.jourNum = jourNum;
            this.tInfo = tInfo;
        }

        /**
         * Получить наименование позиции.
         * @return наименование позиции.
         */
        @NonNull
        public String toString() {
            if ( tInfo != null ) return tInfo;
            return ""; //название не задано
        }
    }

    /** Свободные позиции чека. */
    private static final List<FreeFieldItem> freeFields = new ArrayList<>();

    /** Адаптер для работы с меню. */
    public static class FreeFieldAdapter extends ArrayAdapter<FreeFieldItem> {

        /**
         * Конструктор адаптера.
         * @param context - контекст.
         * @param resource - индекс ресурса.
         * @param items - список.
         */
        FreeFieldAdapter(Context context, int resource, List<FreeFieldItem> items) {
            super(context, resource, items);
        }
    }

    /** Адаптер для работы с listView. */
    private static FreeFieldAdapter adapter;

    /** Слушатель кликов. */
    public class FreeFieldClickListener implements AdapterView.OnItemClickListener {
        @Override
        public void onItemClick(AdapterView<?> l, View itemClicked, int position, long id) {
            FreeFieldDialog(position,"РЕДАКТИРОВАНИЕ РЕКВИЗИТА");
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_receipt_free);

        //создание хендлера
        h = new LibHandler();

        if ( savedInstanceState == null ) {
            //параметры чека по умолчанию

            //параметры чека
            param.flipFOffs = 0;
            param.hCopyNum = 1;
            param.vCopyNum = 1;
            param.LOffs = 0;
            param.LGap = 0;
            param.VGap = 0;
            param.pageNum = 1;

            //обязательные параметры
            posFields.clear();
            for(int i = 0; i<7; i++) {
                posFields.add(new PosField((short)(i+1),(short)0,(byte)0));
            }

            //привязка адаптера
            final ListView listView = findViewById(R.id.listFreeFields);
            adapter = new FreeFieldAdapter(this, R.layout.listview_receipt_item, freeFields);
            listView.setAdapter(adapter);
            listView.setOnItemClickListener( new FreeFieldClickListener() );

            //сумма
            ((TextView)findViewById(R.id.editSum)).setText("1.00");

            //вид оплаты
            ((RadioButton)findViewById(R.id.pay_type_cash)).setChecked(true);
            ((TextView)findViewById(R.id.pay_user)).setText("5");
        }
    }

    @Override
    protected void onStart() {
        super.onStart();

        //регистрация хендлера для получения ответов от контроллера ФН
        TMLib.getInstance().registerHandler(h);

        //заполнение данными
        LoadData();
    }

    @Override
    protected void onStop() {
        //освобождение хендлера
        TMLib.getInstance().unregisterHandler(h);

        //сохранение данных
        SaveData();

        super.onStop();
    }

    /** При позитивном завершении диалога (нажатие кнопки ОК). */
    public void onMessageBoxPositiveClick(DialogInterface dialog) {
        //завершаем активность
        if ( isExit ) finish();
    }

    /** При негативном завершении диалога (нажатие кнопки ОТМЕНА). */
    public void onMessageBoxNegativeClick(DialogInterface dialog) {
    }

    /** Обработка нажатия кнопки ПАРАМЕТРЫ ЧЕКА. */
    public void onButtonParam(View view) {
        //установка вида диалога
        LayoutInflater li = LayoutInflater.from(this);
        View dialogView = li.inflate(R.layout.dialog_receipt_param, null);

        //создаем AlertDialog
        AlertDialog.Builder mDialogBuilder = new AlertDialog.Builder(this);

        //привязка вида диалога к AlertDialog:
        mDialogBuilder.setView(dialogView);

        //настраиваем отображение поля для ввода текста в открытом диалоге:
        final EditText editFlipOffs = dialogView.findViewById(R.id.editFlipOffs);
        final EditText editCopies = dialogView.findViewById(R.id.editCopies);
        final EditText editHCopies = dialogView.findViewById(R.id.editHCopies);
        final EditText editVCopies = dialogView.findViewById(R.id.editVCopies);
        final EditText editHGap = dialogView.findViewById(R.id.editHGap);
        final EditText editVGap = dialogView.findViewById(R.id.editVGap);
        final EditText editLOffs = dialogView.findViewById(R.id.editLOffs);

        //начальные значения
        editFlipOffs.setText(String.valueOf(param.flipFOffs));
        editCopies.setText(String.valueOf(param.pageNum));
        editHCopies.setText(String.valueOf(param.hCopyNum));
        editVCopies.setText(String.valueOf(param.vCopyNum));
        editHGap.setText(String.valueOf(param.LGap));
        editVGap.setText(String.valueOf(param.VGap));
        editLOffs.setText(String.valueOf(param.LOffs));

        //настраиваем диалог:
        mDialogBuilder
                .setCancelable(false)
                .setTitle(getString(R.string.header_receipt_param))
                .setPositiveButton(getString(R.string.btn_ok),
                        (dialog, id) -> {
                            //получаем введенные параметры
                            param.flipFOffs = Byte.parseByte(String.valueOf(editFlipOffs.getText()));
                            param.pageNum = Byte.parseByte(String.valueOf(editCopies.getText()));
                            param.hCopyNum = Byte.parseByte(String.valueOf(editHCopies.getText()));
                            param.vCopyNum = Byte.parseByte(String.valueOf(editVCopies.getText()));
                            param.LGap = Byte.parseByte(String.valueOf(editHGap.getText()));
                            param.VGap = Short.parseShort(String.valueOf(editVGap.getText()));
                            param.LOffs = Short.parseShort(String.valueOf(editLOffs.getText()));
                        })
                .setNegativeButton(getString(R.string.btn_cancel),
                        (dialog, id) -> dialog.cancel());

        //вывод диалога
        mDialogBuilder.create().show();
    }

    /**
     * Редактирование данных обязательной позиции.
     * @param fieldIndex индекс позиции.
     * @param header заголовок диалог
     */
    public void PosFieldDialog(final int fieldIndex, final String header) {
        //установка вида диалога
        LayoutInflater li = LayoutInflater.from(this);
        View dialogView = li.inflate(R.layout.dialog_receipt_pos_field, null);

        //создаем AlertDialog
        AlertDialog.Builder mDialogBuilder = new AlertDialog.Builder(this);

        //привязка вида диалога к AlertDialog:
        mDialogBuilder.setView(dialogView);

        //настраиваем отображение поля для ввода текста в открытом диалоге:
        final EditText editCol = dialogView.findViewById(R.id.editCol);
        final EditText editLine = dialogView.findViewById(R.id.editLine);
        final RadioButton radioFontA = dialogView.findViewById(R.id.radioFontA);
        final RadioButton radioFontB = dialogView.findViewById(R.id.radioFontB);
        final CheckBox cbDoubleWidth = dialogView.findViewById(R.id.doubleWidth);
        final CheckBox cbDoubleHeight = dialogView.findViewById(R.id.doubleHeight);
        final CheckBox cbUnderLine = dialogView.findViewById(R.id.underLine);

        //начальные значения
        PosField curField = posFields.get(fieldIndex);
        if ( curField != null ) {
            //из поля
            editLine.setText(String.valueOf(curField.line));
            editCol.setText(String.valueOf(curField.col));
            if ( (curField.font&TMCommand.FreeFiscalReceipt.fontOptions.type) == 0 ) radioFontA.setChecked(true); else radioFontB.setChecked(true);
            cbDoubleHeight.setChecked((curField.font&TMCommand.FreeFiscalReceipt.fontOptions.doubleHeight)!=0);
            cbDoubleWidth.setChecked((curField.font&TMCommand.FreeFiscalReceipt.fontOptions.doubleWidth)!=0);
            cbUnderLine.setChecked((curField.font&TMCommand.FreeFiscalReceipt.fontOptions.underLine)!=0);
        }
        else {
            //по умолчанию
            radioFontA.setChecked(true);
        }

        //настраиваем диалог:
        mDialogBuilder
                .setCancelable(false)
                .setTitle(header)
                .setPositiveButton(getString(R.string.btn_ok),
                        (dialog, id) -> {
                            //получаем введенные параметры
                            byte font = 0;
                            if ( radioFontB.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.type;
                            if ( cbDoubleHeight.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.doubleHeight;
                            if ( cbDoubleWidth.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.doubleWidth;
                            if ( cbUnderLine.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.underLine;
                            posFields.set(fieldIndex,new PosField(Short.parseShort(String.valueOf(editLine.getText())),Short.parseShort(String.valueOf(editCol.getText())),font));
                        })
                .setNegativeButton(getString(R.string.btn_cancel),
                        (dialog, id) -> dialog.cancel());

        //вывод диалога
        mDialogBuilder.create().show();
    }

    /** Обработка нажатия кнопки ЗАВ.НОМЕР. */
    public void onButtonSN(View view) { PosFieldDialog(0,"НОМЕР ККТ"); }
    /** Обработка нажатия кнопки ЗАВ.НОМЕР. */
    public void onButtonNum(View view) { PosFieldDialog(1,"НОМЕР ЧЕКА"); }
    /** Обработка нажатия кнопки ДАТА. */
    public void onButtonDate(View view) { PosFieldDialog(2,"ДАТА"); }
    /** Обработка нажатия кнопки ВРЕМЯ. */
    public void onButtonTime(View view) { PosFieldDialog(3,"ВРЕМЯ"); }
    /** Обработка нажатия кнопки ИНН. */
    public void onButtonINN(View view) { PosFieldDialog(4,"ИНН"); }
    /** Обработка нажатия кнопки ФИО КАССИРА. */
    public void onButtonCashier(View view) { PosFieldDialog(5,"ФИО КАССИРА"); }
    /** Обработка нажатия кнопки СУММА. */
    public void onButtonSum(View view) { PosFieldDialog(6,"СУММА"); }

    /**
     * Редактирование данных обязательной позиции.
     * @param fieldIndex индекс позиции (-1 - создать новый).
     * @param header заголовок диалог
     */
    public void FreeFieldDialog(final int fieldIndex, final String header) {
        //установка вида диалога
        LayoutInflater li = LayoutInflater.from(this);
        View dialogView = li.inflate(R.layout.dialog_receipt_free_field, null);

        //создаем AlertDialog
        AlertDialog.Builder mDialogBuilder = new AlertDialog.Builder(this);

        //настраиваем prompt.xml для нашего AlertDialog:
        mDialogBuilder.setView(dialogView);

        //настраиваем отображение поля для ввода текста в открытом диалоге:
        final EditText editCol = dialogView.findViewById(R.id.editCol);
        final EditText editLine = dialogView.findViewById(R.id.editLine);
        final EditText editJourNum = dialogView.findViewById(R.id.editJourNum);
        final EditText editInfo = dialogView.findViewById(R.id.editInfo);
        final RadioButton radioFontA = dialogView.findViewById(R.id.radioFontA);
        final RadioButton radioFontB = dialogView.findViewById(R.id.radioFontB);
        final CheckBox cbDoubleWidth = dialogView.findViewById(R.id.doubleWidth);
        final CheckBox cbDoubleHeight = dialogView.findViewById(R.id.doubleHeight);
        final CheckBox cbUnderLine = dialogView.findViewById(R.id.underLine);
        final RadioButton radioMode0 = dialogView.findViewById(R.id.radioButtonMode0);
        final RadioButton radioMode1 = dialogView.findViewById(R.id.radioButtonMode1);
        final RadioButton radioMode2 = dialogView.findViewById(R.id.radioButtonMode2);

        //начальные значения
        FreeFieldItem curField = (fieldIndex<0)?new FreeFieldItem((short)0,(short)0,(byte)0,(byte)0,(byte)0,""):freeFields.get(fieldIndex);
        if ( curField != null ) {
            //из поля
            editLine.setText(String.valueOf(curField.line));
            editCol.setText(String.valueOf(curField.col));
            editJourNum.setText(String.valueOf(curField.jourNum));
            editInfo.setText(curField.tInfo);
            if ( (curField.font&TMCommand.FreeFiscalReceipt.fontOptions.type) == 0 ) radioFontA.setChecked(true); else radioFontB.setChecked(true);
            cbDoubleHeight.setChecked((curField.font&TMCommand.FreeFiscalReceipt.fontOptions.doubleHeight)!=0);
            cbDoubleWidth.setChecked((curField.font&TMCommand.FreeFiscalReceipt.fontOptions.doubleWidth)!=0);
            cbUnderLine.setChecked((curField.font&TMCommand.FreeFiscalReceipt.fontOptions.underLine)!=0);
            switch(curField.printMode) {
                default:
                case 1: radioMode0.setChecked(true); break;
                case 2: radioMode1.setChecked(true); break;
                case 3: radioMode2.setChecked(true); break;
            }
        }

        //настраиваем сообщение в диалоговом окне:
        mDialogBuilder
                .setCancelable(false)
                .setTitle(header);

        //настройка кнопок
        mDialogBuilder.
                setPositiveButton(getString((fieldIndex<0)?R.string.btn_add:R.string.btn_save),
                        (dialog, id) -> {
                            //получаем введенные параметры
                            byte font = 0;
                            if ( radioFontB.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.type;
                            if ( cbDoubleHeight.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.doubleHeight;
                            if ( cbDoubleWidth.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.doubleWidth;
                            if ( cbUnderLine.isChecked() ) font |= TMCommand.FreeFiscalReceipt.fontOptions.underLine;
                            byte printMode = 1;
                            if ( radioMode1.isChecked() ) printMode = 2;
                            else if ( radioMode2.isChecked() ) printMode = 3;
                            FreeFieldItem curItem = new FreeFieldItem(Short.parseShort(String.valueOf(editLine.getText())),Short.parseShort(String.valueOf(editCol.getText())),font,printMode,Byte.parseByte(String.valueOf(editJourNum.getText())),String.valueOf(editInfo.getText()));
                            if ( fieldIndex < 0 ) {
                                freeFields.add(curItem);
                            }
                            else {
                                freeFields.set(fieldIndex, curItem);
                            }
                            adapter.notifyDataSetChanged();
                        });
        if (fieldIndex >= 0) mDialogBuilder.
                setNeutralButton(getString(R.string.btn_delete),
                        (dialog, id) -> {
                            freeFields.remove(fieldIndex);
                            adapter.notifyDataSetChanged();
                        });
        mDialogBuilder.
                setNegativeButton(getString(R.string.btn_cancel),
                        (dialog, id) -> dialog.cancel());

        //вывод диалога
        mDialogBuilder.create().show();
    }

    /** Обработка нажатия кнопки ДОБАВИТЬ РЕКВИЗИТ. */
    public void onButtonAdd(View view) { FreeFieldDialog(-1,"ДОБАВЛЕНИЕ РЕКВИЗИТА"); }

    /** Обработка нажатия кнопки ОК. */
    public void onButtonOK(View view) {
        //считываем настройки чека
        String sum = String.valueOf(((TextView)findViewById(R.id.editSum)).getText());
        String cashier = String.valueOf(((TextView)findViewById(R.id.seller_name)).getText());
        if (sum.isEmpty()) {
            MessageBox.Create(getString(R.string.header_error), "Не введена сумма чека", MessageBox.option.OK | MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }
        else if (cashier.isEmpty()) {
            MessageBox.Create(getString(R.string.header_error), "Не введено ФИО Кассира", MessageBox.option.OK | MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }
        else if (freeFields.isEmpty()) {
            MessageBox.Create(getString(R.string.header_error), "Не введено ни одного произвольного реквизита", MessageBox.option.OK | MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }
        else {
            String barText = String.valueOf(((TextView)findViewById(R.id.barcode_text)).getText());
            if (barText.isEmpty()) {
                //сразу выполняем команду произвольного чека
                FRReceiptFree();
            }
            else {
                //сперва выполняем команду построения 2D кода
                TMCommand cmd = new TMCommand();
                if ( barText.startsWith("QR:") ) {
                    //подготовка QR кода
                    cmd.CmdBar2Dprepare((byte)4,(byte)4,"0",barText);
                }
                else if ( barText.startsWith("DM:") ) {
                    //подготовка DataMatrix кода
                    cmd.CmdBar2Dprepare((byte)1,(byte)1,"0",barText);
                }
                else {
                    //подготовка PDF кода
                    cmd.CmdBar2Dprepare((byte)6,(byte)6,"0.5",barText);
                }
                TMLib.getInstance().DoCmd(this,cmd,5000);
            }
        }
    }

    /** Обработка нажатия кнопки ОТМЕНА. */
    public void onButtonCancel(View view) {
        finish(); //завершение диалога
    }

    /** Сохранение данных чека. */
    private void SaveData() {
        try {
            Document tree = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element mainNode = tree.createElement("ReceiptFree");
            //заполнение данными
            String sum = String.valueOf(((TextView)findViewById(R.id.editSum)).getText());
            String cashier = String.valueOf(((TextView)findViewById(R.id.seller_name)).getText());
            String barText = String.valueOf(((TextView)findViewById(R.id.barcode_text)).getText());
            //индекс оплаты
            byte payIndex = (
                    ((RadioButton)findViewById(R.id.pay_type_cash)).isChecked()?TMCommand.pay_indexes.CASH:
                    ((RadioButton)findViewById(R.id.pay_type_card)).isChecked()?TMCommand.pay_indexes.CARD:
                    ((RadioButton)findViewById(R.id.pay_type_advance)).isChecked()?TMCommand.pay_indexes.ADVANCE:
                    ((RadioButton)findViewById(R.id.pay_type_credit)).isChecked()?TMCommand.pay_indexes.CREDIT:
                    ((RadioButton)findViewById(R.id.pay_type_other)).isChecked()?TMCommand.pay_indexes.OTHER:
                    Byte.parseByte(String.valueOf(((TextView)findViewById(R.id.pay_user)).getText())));
            //тип чека
            byte type = 0;
            switch(((Spinner)findViewById(R.id.receipt_type)).getSelectedItemPosition()) {
                case 0: type = TMCommand.receipt_types.SALE; break;
                case 1: type = TMCommand.receipt_types.REVERSE; break;
                case 2: type = TMCommand.receipt_types.PURCHASE; break;
                case 3: type = TMCommand.receipt_types.REVERSE_PURCHASE; break;
            }
            mainNode.setAttribute("sum",sum);
            mainNode.setAttribute("cashier",cashier);
            mainNode.setAttribute("barText",barText);
            mainNode.setAttribute("type",String.valueOf(type));
            mainNode.setAttribute("payIndex",String.valueOf(payIndex));
            //параметры чека
            mainNode.setAttribute("flipFOffs",String.valueOf(param.flipFOffs));
            mainNode.setAttribute("pageNum",String.valueOf(param.pageNum));
            mainNode.setAttribute("hCopyNum",String.valueOf(param.hCopyNum));
            mainNode.setAttribute("vCopyNum",String.valueOf(param.vCopyNum));
            mainNode.setAttribute("LGap",String.valueOf(param.LGap));
            mainNode.setAttribute("LOffs",String.valueOf(param.LOffs));
            mainNode.setAttribute("VGap",String.valueOf(param.VGap));
            tree.appendChild(mainNode);
            //обязательные параметры
            if (!posFields.isEmpty()) {
                Element posNode = tree.createElement("pos");
                mainNode.appendChild(posNode);
                for (PosField field : posFields) {
                    Element fieldNode = tree.createElement("field");
                    fieldNode.setAttribute("line", String.valueOf(field.line));
                    fieldNode.setAttribute("col", String.valueOf(field.col));
                    fieldNode.setAttribute("font", String.valueOf(field.font));
                    posNode.appendChild(fieldNode);
                }
            }
            //произвольные параметры
            if (!freeFields.isEmpty()) {
                Element freeNode = tree.createElement("free");
                mainNode.appendChild(freeNode);
                for (FreeFieldItem field : freeFields) {
                    Element fieldNode = tree.createElement("field");
                    fieldNode.setAttribute("line", String.valueOf(field.line));
                    fieldNode.setAttribute("col", String.valueOf(field.col));
                    fieldNode.setAttribute("font", String.valueOf(field.font));
                    fieldNode.setAttribute("jourNum", String.valueOf(field.jourNum));
                    fieldNode.setAttribute("printMode", String.valueOf(field.printMode));
                    fieldNode.setAttribute("tInfo", field.tInfo);
                    freeNode.appendChild(fieldNode);
                }
            }
            //сохранение данных в файл
            File f = new File(getFilesDir(), RECEIPT_NAME);
            f.delete();
            DOMSource domSource = new DOMSource(tree);
            FileWriter writer = new FileWriter(f);
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            //MessageBox.Create("XML", getStringFromDocument(tree), MessageBox.option.OK).show(getFragmentManager(), "MessageBox");
        }
        catch(Exception e) {
            Log.e(this.getLocalClassName(),"SaveData fail: "+e.getLocalizedMessage());
        }
    }

    /** Чтение данных чека. */
    private void LoadData() {
        try {
            File f = new File(getFilesDir(), RECEIPT_NAME);
            if ( f.exists() && (f.length() > 0)) {
                //файл есть
                InputStream fis = new FileInputStream(f);
                Document tree = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fis);
                if (tree != null) {
                    //ищем корневую ноду
                    Node var = tree.getFirstChild();
                    while (var != null) {
                        String s = var.getNodeName();
                        if ((s != null) && (s.equals("ReceiptFree"))) break;
                        var = var.getNextSibling();
                    }
                    if ( var != null ) {
                        //найден корень
                        Element mainNode = (Element)var;
                        //чтение данных
                        String tmp = mainNode.getAttribute("sum");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) ((TextView)findViewById(R.id.editSum)).setText(tmp);
                        tmp = mainNode.getAttribute("cashier");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) ((TextView)findViewById(R.id.seller_name)).setText(tmp);
                        tmp = mainNode.getAttribute("barText");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) ((TextView)findViewById(R.id.barcode_text)).setText(tmp);
                        tmp = mainNode.getAttribute("type");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) {
                            byte type = Byte.parseByte(tmp);
                            switch(type) {
                                case TMCommand.receipt_types.SALE: ((Spinner)findViewById(R.id.receipt_type)).setSelection(0); break;
                                case TMCommand.receipt_types.REVERSE: ((Spinner)findViewById(R.id.receipt_type)).setSelection(1); break;
                                case TMCommand.receipt_types.PURCHASE: ((Spinner)findViewById(R.id.receipt_type)).setSelection(2); break;
                                case TMCommand.receipt_types.REVERSE_PURCHASE: ((Spinner)findViewById(R.id.receipt_type)).setSelection(3); break;
                            }
                        }
                        tmp = mainNode.getAttribute("payIndex");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) {
                            byte payIndex = Byte.parseByte(tmp);
                            switch (payIndex) {
                                case TMCommand.pay_indexes.CASH: ((RadioButton)findViewById(R.id.pay_type_cash)).setChecked(true); break;
                                case TMCommand.pay_indexes.CARD: ((RadioButton)findViewById(R.id.pay_type_card)).setChecked(true); break;
                                case TMCommand.pay_indexes.ADVANCE: ((RadioButton)findViewById(R.id.pay_type_advance)).setChecked(true); break;
                                case TMCommand.pay_indexes.CREDIT: ((RadioButton)findViewById(R.id.pay_type_credit)).setChecked(true); break;
                                case TMCommand.pay_indexes.OTHER: ((RadioButton)findViewById(R.id.pay_type_other)).setChecked(true); break;
                                default:
                                    ((RadioButton)findViewById(R.id.pay_type_user)).setChecked(true);
                                    ((TextView)findViewById(R.id.pay_user)).setText(String.valueOf(payIndex));
                                    break;
                            }
                        }
                        //чтение параметров чека
                        tmp = mainNode.getAttribute("flipFOffs");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) param.flipFOffs = Byte.parseByte(tmp);
                        tmp = mainNode.getAttribute("pageNum");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) param.pageNum = Byte.parseByte(tmp);
                        tmp = mainNode.getAttribute("hCopyNum");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) param.hCopyNum = Byte.parseByte(tmp);
                        tmp = mainNode.getAttribute("vCopyNum");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) param.vCopyNum = Byte.parseByte(tmp);
                        tmp = mainNode.getAttribute("LGap");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) param.LGap = Byte.parseByte(tmp);
                        tmp = mainNode.getAttribute("LOffs");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) param.LOffs = Short.parseShort(tmp);
                        tmp = mainNode.getAttribute("VGap");
                        if ( ( tmp != null ) && (!tmp.isEmpty()) ) param.VGap = Short.parseShort(tmp);
                        //чтение обязательных полей
                        var = mainNode.getFirstChild();
                        while (var != null) {
                            String s = var.getNodeName();
                            if ((s != null) && (s.equals("pos"))) break;
                            var = var.getNextSibling();
                        }
                        if ( var != null ) {
                            Element posNode = (Element)var;
                            int i = 0;
                            var = posNode.getFirstChild();
                            while ( (var != null) && ( i < 7 ) ) {
                                String s = var.getNodeName();
                                if ((s != null) && (s.equals("field"))) {
                                    //найдено поле
                                    Element fieldNode = (Element)var;
                                    short col = 0;
                                    short line = 0;
                                    byte font = 0;
                                    tmp = fieldNode.getAttribute("line");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) line = Short.parseShort(tmp);
                                    tmp = fieldNode.getAttribute("col");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) col = Short.parseShort(tmp);
                                    tmp = fieldNode.getAttribute("font");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) font = Byte.parseByte(tmp);
                                    posFields.set(i,new PosField(line,col,font));
                                    i++;
                                }
                                var = var.getNextSibling();
                            }
                        }
                        //чтение произвольных полей
                        var = mainNode.getFirstChild();
                        while (var != null) {
                            String s = var.getNodeName();
                            if ((s != null) && (s.equals("free"))) break;
                            var = var.getNextSibling();
                        }
                        if ( var != null ) {
                            Element freeNode = (Element)var;
                            freeFields.clear();
                            var = freeNode.getFirstChild();
                            while (var != null) {
                                String s = var.getNodeName();
                                if ((s != null) && (s.equals("field"))) {
                                    //найдено поле
                                    Element fieldNode = (Element)var;
                                    short col = 0;
                                    short line = 0;
                                    byte font = 0;
                                    byte printMode = 0;
                                    byte jourNum = 0;
                                    String tInfo = "";
                                    tmp = fieldNode.getAttribute("line");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) line = Short.parseShort(tmp);
                                    tmp = fieldNode.getAttribute("col");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) col = Short.parseShort(tmp);
                                    tmp = fieldNode.getAttribute("font");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) font = Byte.parseByte(tmp);
                                    tmp = fieldNode.getAttribute("jourNum");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) jourNum = Byte.parseByte(tmp);
                                    tmp = fieldNode.getAttribute("printMode");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) printMode = Byte.parseByte(tmp);
                                    tmp = fieldNode.getAttribute("tInfo");
                                    if ( ( tmp != null ) && (!tmp.isEmpty()) ) tInfo = tmp;
                                    freeFields.add(new FreeFieldItem(line,col,font,printMode,jourNum,tInfo));
                                }
                                var = var.getNextSibling();
                            }
                            adapter.notifyDataSetChanged();
                        }
                    }
                }
            }
        }
        catch(Exception e) {
            Log.e(this.getLocalClassName(),"LoadData fail: "+e.getLocalizedMessage());
        }
    }

    /** Создание команды произвольного чека. */
    private void FRReceiptFree() {
        //считываем настройки чека
        String sum = String.valueOf(((TextView)findViewById(R.id.editSum)).getText());
        String cashier = String.valueOf(((TextView)findViewById(R.id.seller_name)).getText());
        //индекс оплаты
        byte payIndex = (
                ((RadioButton)findViewById(R.id.pay_type_cash)).isChecked()?TMCommand.pay_indexes.CASH:
                        ((RadioButton)findViewById(R.id.pay_type_card)).isChecked()?TMCommand.pay_indexes.CARD:
                                ((RadioButton)findViewById(R.id.pay_type_advance)).isChecked()?TMCommand.pay_indexes.ADVANCE:
                                        ((RadioButton)findViewById(R.id.pay_type_credit)).isChecked()?TMCommand.pay_indexes.CREDIT:
                                                ((RadioButton)findViewById(R.id.pay_type_other)).isChecked()?TMCommand.pay_indexes.OTHER:
                                                        Byte.parseByte(String.valueOf(((TextView)findViewById(R.id.pay_user)).getText())));
        //тип чека
        byte type = 0;
        switch(((Spinner)findViewById(R.id.receipt_type)).getSelectedItemPosition()) {
            case 0: type = TMCommand.receipt_types.SALE; break;
            case 1: type = TMCommand.receipt_types.REVERSE; break;
            case 2: type = TMCommand.receipt_types.PURCHASE; break;
            case 3: type = TMCommand.receipt_types.REVERSE_PURCHASE; break;
        }

        //заполняем данные чеки
        TMCommand.FreeFiscalReceipt receipt =  new TMCommand.FreeFiscalReceipt(type,payIndex,param.flipFOffs,param.pageNum,param.hCopyNum,param.vCopyNum,param.LOffs,param.VGap,param.LGap,sum,cashier,"");
        //добавление обязательных полей
        receipt.AddPosFields(
                posFields.get(0).line,posFields.get(0).col,posFields.get(0).font,
                posFields.get(1).line,posFields.get(1).col,posFields.get(1).font,
                posFields.get(2).line,posFields.get(2).col,posFields.get(2).font,
                posFields.get(3).line,posFields.get(3).col,posFields.get(3).font,
                posFields.get(4).line,posFields.get(4).col,posFields.get(4).font,
                posFields.get(5).line,posFields.get(5).col,posFields.get(5).font,
                posFields.get(6).line,posFields.get(6).col,posFields.get(6).font);
        //добавление произвольных полей
        for(FreeFieldItem item:freeFields) {
            receipt.AddFreeField(item.line,item.col,item.font,item.printMode,item.jourNum,item.tInfo);
        }

        //создание и выполнение команды
        TMCommand cmd = new TMCommand();
        cmd.CmdReceiptFree(receipt);
        TMLib.getInstance().DoCmd(this,cmd,5000);
    }

    /** Хендлер для обработки сообщений от контроллера ФН. */
    private class LibHandler extends TMLibHandler {

        /** Конструктор по умолчанию. */
        public LibHandler(){
            super(MainApp.GetCtx().getMainLooper());
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получен ответ на команду
            if ( cmd.GetMainError() != 0 ) {
                //сообщение об ошибке выполнения команды
                MessageBox.Create(getString(R.string.header_error), String.format(getString(R.string.msg_cmd_error), cmd.GetMainError(), cmd.GetSubError(), cmd.GetCmdCode()) + "\n\n" + TMError.GetText((byte) cmd.GetMainError()), MessageBox.option.OK | MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
            }
            else {
                //обработка успешных ответов
                switch((byte) cmd.GetCmdCode()) {
                    case TMCommand.commands.CM_Bar2Dprepare:
                        //штрихкод подготовлен - создаем чек
                        FRReceiptFree();
                        break;

                    case TMCommand.commands.CM_ReceiptFree:
                        //чек создан успешно
                        isExit = true;
                        TMLib.getInstance().StartOFD();
                        MessageBox.Create(getString(R.string.header_success), getString(R.string.msg_cmd_success)+"\n\nЗАБЕРИТЕ ЧЕК", MessageBox.option.OK).show(getSupportFragmentManager(), MessageBox.TAG);
                        break;
                }
            }
        }

        @Override
        public void onTimeOut() {
            //сообщение о превышении таймаута обращения к контроллеру ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_timeout), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_service_fail)+"\n\n"+errText, MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }
    }
}
