package ru.nilsoft.example;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;

import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.text.InputType;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.PopupMenu;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.android.Intents;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.journeyapps.barcodescanner.ScanContract;
import com.journeyapps.barcodescanner.ScanOptions;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMError;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMMarkCode;
import ru.nilsoft.tm.TMOismHandler;
import ru.nilsoft.tm.TMTag;

/**
 * Сборка фискального документа.
 *
 * Состоит из нескольких этапов:
 * - открытие документа;
 * - добавление позиций предмета расчета (там же добавление агентской информации);
 * - проверка маркированного товара (если требуется);
 * - добавление/прием оплат/расчета;
 * - закрытие документа.
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class ReceiptActivity extends AppCompatActivity implements MessageBox.CallBack {
    /** Handler для работы c контроллером ФН. */
    private static ReceiptHandler h = null;
    /** Выход из диалога. */
    private boolean isExit = false;
    /** Сумма чека. */
    private static String sReceiptTotal = CommonFunc.CURRENCY_ZERO;
    /** Сумма чека. */
    private static String sReceiptRemaind = CommonFunc.CURRENCY_ZERO;
    /** Параметры чека. */
    private static Cheque cheque = null;
    /** Список товара. */
    private static ArrayList<Good> goodList = null;
    /** Текущий товар. */
    private static int currentGood;
    /** QR код чека. */
    private static String sQR = null;
    /** Если есть маркированный товар в чеке. */
    private static boolean isKM = false;
    /** Диалог отображаемый при проверке КМ товара. */
    private static AlertDialog dlgValidateKM = null;
    /** Версия ФФД при регистрации. */
    private static byte ffdVer = 0;

    /** Тэги для добавления товара (реквизиты агента). */
    private static String sTag1073 = "";
    private static String sTag1074 = "";
    private static String sTag1075 = "";
    private static String sTag1044 = "";
    private static String sTag1026 = "";
    private static String sTag1005 = "";
    private static String sTag1016 = "";
    private static String sTag1226 = "";
    private static String sTag1171 = "";
    private static String sTag1225 = "";

    /** Год документа (коррекции). */
    private static int docYear;
    /** Месяц документа (коррекции) [получается через DataPicker - то есть январь == 0]. */
    private static int docMonth;
    /** День документа (коррекции). */
    private static int docDay;

    /** Фрагмент открытия чека. */
    FragmentOpen fragmentOpen;
    /** Фрагмент добавления товара в чек. */
    FragmentAdd fragmentAdd;
    /** Фрагмент ввода реквизитов агента. */
    FragmentAgent fragmentAgent;
    /** Фрагмент оплаты чека. */
    FragmentPay fragmentPay;
    /** Метки фрагментов. */
    final static String TAG_OPEN = "RECEIPT_OPEN";
    final static String TAG_ADD = "RECEIPT_ADD";
    final static String TAG_PAY = "RECEIPT_PAY";
    final static String TAG_AGENT = "RECEIPT_AGENT";

    /** Описание чека. */
    private class Cheque {
        /** Поля описание чека. */
        byte type;
        String sSellerName;
        String sSellerINN;
        String sNumTable;
        String sNumPlace;
        byte copies;
        byte tax_system;
        String sAccount;
        String sComment;

        Cheque(View v) {
            //информация о кассире
            sSellerName = String.valueOf(((TextView)v.findViewById(R.id.fio_kassir)).getText());
            sSellerINN = String.valueOf(((TextView)v.findViewById(R.id.inn_kassir)).getText());

            //информация о чеке
            sNumTable = String.valueOf(((TextView)v.findViewById(R.id.num_table)).getText());
            sNumPlace = String.valueOf(((TextView)v.findViewById(R.id.num_place)).getText());
            sAccount = String.valueOf(((TextView)v.findViewById(R.id.account)).getText());

            //система налогообложения
            try {
                String[] systemTypes = getResources().getStringArray(R.array.systemnalog);
                tax_system = MainApp.GetTaxSystemCode(systemTypes[((Spinner) v.findViewById(R.id.tax_system)).getSelectedItemPosition()]);
            }
            catch(Exception ex) {
                tax_system = TMCommand.tax_types.DEFAULT;
            }

            //коментарий к чеку
            sComment = String.valueOf(((TextView)v.findViewById(R.id.comment)).getText());

            //количество копий
            try {
                copies = Byte.parseByte(String.valueOf(((TextView)v.findViewById(R.id.copies)).getText()));
            }
            catch(Exception e) {
                copies = 1;
            }

            //дополнительные теги
            String sTag1008 = String.valueOf(((TextView)v.findViewById(R.id.editTag1008)).getText());
            String sTag1187 = String.valueOf(((TextView)v.findViewById(R.id.editTag1187)).getText());
            if ( !sTag1008.isEmpty() ) sComment = CommonFunc.addTag(sComment,1008,sTag1008);
            if ( !sTag1187.isEmpty() ) sComment = CommonFunc.addTag(sComment,1187,sTag1187);

            //тип чека
            if ( ((CheckBox)v.findViewById(R.id.is_correction)).isChecked() ) {
                //чек коррекции
                switch(((Spinner)v.findViewById(R.id.receipt_type)).getSelectedItemPosition()) {
                    case 0: type = TMCommand.receipt_types.CORR_SALE; break;
                    case 1: type = TMCommand.receipt_types.CORR_REVERSE_SALE; break;
                    case 2: type = TMCommand.receipt_types.CORR_PURCHASE; break;
                    case 3: type = TMCommand.receipt_types.CORR_REVERSE_PURCHASE; break;
                }
                //считываем дополнительные параметры
                String sTag1192 = String.valueOf(((TextView)v.findViewById(R.id.editCorrTag1192)).getText());
                String sTag1179 = String.valueOf(((TextView)v.findViewById(R.id.editCorrTag1179)).getText());
                byte corrType = 0;
                switch(((Spinner)v.findViewById(R.id.correction_type)).getSelectedItemPosition()) {
                    case 0: corrType = TMCommand.correction_types.SELF; break;
                    case 1: corrType = TMCommand.correction_types.ORDER; break;
                }
                //сборка тегов в комментарий
                sComment = CommonFunc.addTag(sComment,1178,String.format("%02d.%02d.%02d",docDay,docMonth+1,docYear%100));
                if ( !sTag1192.isEmpty() ) sComment = CommonFunc.addTag(sComment,1192,sTag1192);
                if ( !sTag1179.isEmpty() ) sComment = CommonFunc.addTag(sComment,1179,sTag1179);
                sComment = CommonFunc.addTag(sComment,1173,String.valueOf(corrType));

                //sComment = String.format("<1173>%d|",corrType)+String.format("<1178>%02d.%02d.%02d|",docDay,docMonth+1,docYear%100)+"<1177>"+sTag1177+"|"+"<1179>"+sTag1179+((sComment.length()>0)?"|"+sComment:"");
            }
            else {
                //обычный чек
                switch(((Spinner)v.findViewById(R.id.receipt_type)).getSelectedItemPosition()) {
                    case 0: type = TMCommand.receipt_types.SALE; break;
                    case 1: type = TMCommand.receipt_types.REVERSE; break;
                    case 2: type = TMCommand.receipt_types.PURCHASE; break;
                    case 3: type = TMCommand.receipt_types.REVERSE_PURCHASE; break;
                }
            }
            type += (((CheckBox)v.findViewById(R.id.elect_form)).isChecked()?TMCommand.receipt_types.ONLINE_FLAG:(byte)0);
        }

        /** Открытие чека КФН */
        void open(String sDate, String sTime) {
            //выполнение команды
            h.DoCmdReceiptOpen(
                    sDate, sTime,
                    type,
                    sSellerName, sSellerINN,
                    sNumTable, sNumPlace,
                    copies,
                    tax_system,
                    sAccount,
                    sComment);
        }
    }

    /** Описание товара. */
    private class Good {
        // Поля описания товара:

        /** Название товара. */
        private final String sName;
        /** Код/артикул товара. */
        private final String sCode;
        /** Цена за единицу товара. */
        private final String sPrice;
        /** Количество товара. */
        private final String sQty;
        /** Название единицы измерения товара. */
        private final String sUnit;
        /** Индекс налога на товар (НДС). */
        private final byte taxIndex;
        /** Метод расчета. */
        private final byte calcMethod;
        /** Предмет расчета. */
        private final byte calcObject;
        /** Номер отдела. */
        private final byte depNum;
        /** Название отдела. */
        private final String sDepName;

        /** Типы агента. */
        private byte agent;
        /** Дополнительные теги товара. */
        private String sRekvisit;

        /** Штрих-код маркировки. */
        private final String sBarCode;
        /** Количество товара в упаковке. */
        private final int lotSize;

        /** Статус проверки КМ в ОИСМ. */
        private byte statusKM;
        /** Планируемый статус проверки КМ в ОИСМ. */
        private byte plannedKM;
        /** Необходимость проверки в ОИСМ. */
        private boolean isOismCheckKM;

        /**
         * Инициализация класса считываем все из полей диалога.
         * @param v форма с данными товарной позиции.
         */
        Good(View v) {
            sName = String.valueOf(((TextView) v.findViewById(R.id.good_name)).getText());
            sCode = String.valueOf(((TextView) v.findViewById(R.id.good_code)).getText());
            sPrice = String.valueOf(((TextView) v.findViewById(R.id.good_price)).getText());
            sQty = String.valueOf(((TextView) v.findViewById(R.id.good_qty)).getText());
            sUnit = String.valueOf(((TextView) v.findViewById(R.id.good_unit)).getText());
            sDepName = String.valueOf(((TextView) v.findViewById(R.id.dep_name)).getText());
            sBarCode = convertKM(String.valueOf(((TextView) v.findViewById(R.id.bar_code)).getText()));
            isOismCheckKM = ((CheckBox)v.findViewById(R.id.bar_code_oism_check)).isChecked();

            //проверка обязательных полей
            if (sName.isEmpty()) {
                MessageBox.Create(getString(R.string.header_warning), getString(R.string.msg_bad_good_name), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
                throw new NullPointerException(getString(R.string.msg_bad_good_name));
            }
            else if ( CommonFunc.ValueIsZero(sQty) ){
                MessageBox.Create(getString(R.string.header_warning), getString(R.string.msg_bad_good_qty), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
                throw new NullPointerException(getString(R.string.msg_bad_good_qty));
            }

            //проверка номера отдела
            try {
                depNum = Byte.parseByte(String.valueOf(((TextView) v.findViewById(R.id.dep_num)).getText()));
            }
            catch(Exception ignored) {
                MessageBox.Create(getString(R.string.header_warning), getString(R.string.msg_bad_dep_num), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
                throw new NullPointerException(getString(R.string.msg_bad_dep_num));
            }

            //ставка налога
            taxIndex = (byte) ((Spinner) v.findViewById(R.id.tax_index)).getSelectedItemPosition();

            //признак предмета рассчета
            calcMethod = (byte) (((Spinner) v.findViewById(R.id.calc_method)).getSelectedItemPosition() + 1);

            //признак предмета рассчета
            //ВНИМАНИЕ: после 27 сразу 30 индекс (смотри ФФД 1.2) признака предмета рассчета
            byte calcObjectIndex = (byte) (((Spinner) v.findViewById(R.id.calc_object)).getSelectedItemPosition() + 1);
            calcObject = (byte)((calcObjectIndex > 27)?calcObjectIndex+2:calcObjectIndex);

            //количество в упаковке
            String sLotSize = String.valueOf(((TextView) v.findViewById(R.id.lot_size)).getText());
            lotSize = (sLotSize.isEmpty() || (Integer.parseInt(sLotSize) == 0) )?0:Integer.parseInt(sLotSize);

            //прочее для КМ
            statusKM = 0;
            plannedKM = 1;

            //получение битов агентской схемы
            agent = 0;
            if (((CheckBox) v.findViewById(R.id.bank_agent)).isChecked()) agent |= TMCommand.agent_type.BANK_PAY_AGENT;
            if (((CheckBox) v.findViewById(R.id.bank_subagent)).isChecked()) agent |= TMCommand.agent_type.BANK_PAY_SUBAGENT;
            if (((CheckBox) v.findViewById(R.id.pay_agent)).isChecked()) agent |= TMCommand.agent_type.PAY_AGENT;
            if (((CheckBox) v.findViewById(R.id.pay_subagent)).isChecked()) agent |= TMCommand.agent_type.PAY_SUBAGENT;
            if (((CheckBox) v.findViewById(R.id.confidant)).isChecked()) agent |= TMCommand.agent_type.CONFIDANT;
            if (((CheckBox) v.findViewById(R.id.broker)).isChecked()) agent |= TMCommand.agent_type.BROKER;
            if (((CheckBox) v.findViewById(R.id.agent_other)).isChecked()) agent |= TMCommand.agent_type.OTHER;

            //сборка реквизита
            sRekvisit = String.valueOf(((TextView)v.findViewById(R.id.good_comment)).getText());

            //необязательный реквизит
            sRekvisit = CommonFunc.addTag(sRekvisit,1191,String.valueOf(((TextView)v.findViewById(R.id.tag_1191)).getText()));

            if ( !h.IsTMT() && (!sBarCode.isEmpty()) ) {
                //работа с маркировкой не поддерживается
                //добавляется тег 1162 с конверченными данными
                sRekvisit = CommonFunc.addTag(sRekvisit, ((h.GetFFDVersion() >= TMCommand.proto_ffd.FFD_1_2)? TMTag.FFD12_KT:TMTag.FFD11_KT), TMMarkCode.ConvertTo1162(sBarCode));
            }
            if (agent != 0) {
                //установлена поддержка агентов
                sRekvisit = CommonFunc.addTag(sRekvisit,1073,sTag1073);
                sRekvisit = CommonFunc.addTag(sRekvisit,1074,sTag1074);
                sRekvisit = CommonFunc.addTag(sRekvisit,1075,sTag1075);
                sRekvisit = CommonFunc.addTag(sRekvisit,1044,sTag1044);
                sRekvisit = CommonFunc.addTag(sRekvisit,1026,sTag1026);
                sRekvisit = CommonFunc.addTag(sRekvisit,1005,sTag1005);
                sRekvisit = CommonFunc.addTag(sRekvisit,1016,sTag1016);
                sRekvisit = CommonFunc.addTag(sRekvisit,1226,sTag1226);
                sRekvisit = CommonFunc.addTag(sRekvisit,1171,sTag1171);
                sRekvisit = CommonFunc.addTag(sRekvisit,1225,sTag1225);
            }

            //сбрасываем поля
            ((TextView)v.findViewById(R.id.bar_code)).setText("");
        }

        /**
         * Получение имени товара.
         * @return имя товара.
         */
        String getName() {
            return sName;
        }

        /**
         * Получение маркировочного кода.
         * @return строка маркировочного кода.
         */
        String getBarCode() {
            return sBarCode;
        }

        boolean getIsCheckInOISM() { return isOismCheckKM;}

        void setIsCheckOISM(boolean isCheck){
            isOismCheckKM = isCheck;
        }

        /**
         * Добавление статусов проверки маркировочного кода.
         * @param item результаты проверки.
         */
        void setStatusKM(TMOismHandler.Item item) {
            statusKM = item.statusKM;
            plannedKM = item.planStatusKM;
        }

        /**
         * Создание итема для процедуры проверки маркировочного кода.
         * @return итем для передачи в процедуру.
         */
        TMOismHandler.Item getForValidate(){
            return new TMOismHandler.Item(sBarCode,sQty,sUnit,lotSize);
        }

        /**
         * Добавление маркировки в чек КФН.
         * @return true: код маркировки добавлен, false: нет кода маркировки.
         */
        boolean transferKM() {
            if ( h.IsTMT() && !sBarCode.isEmpty() ) {
                //добавление маркировки в чек КФН
                h.DoCmdKMTransfer(TMMarkCode.GetTag(sBarCode),sBarCode.getBytes(),TMMarkCode.GS1GetSize_GTIN(sBarCode),(byte)0,TMMarkCode.GetType(sBarCode),plannedKM,(byte)0,statusKM);
                return true;
            }
            return false;
        }

        /** Добавление товара в чек (команда к контроллеру ФН). */
        void add() {
            //учитываем лоты для количества
            String qty = sQty;
            if ( h.IsTMT() && !sBarCode.isEmpty() && (lotSize > 0) ) {
                //учитываем размер лота в случае использования маркировки
                qty = sQty+"/"+lotSize;
            }

            //для ФФД1.2 преобразовываем идентификатор в hex
            String unit = (h.GetFFDVersion() >= TMCommand.proto_ffd.FFD_1_2)?TMCommand.GetUnitIDHex(sUnit):sUnit;

            //приводим цену к нормальному виду
            String price = CommonFunc.ValueRound(sPrice,CommonFunc.CURRENCY_RADIX);

            h.DoCmdReceiptItem(sName, sCode, price, qty, unit, taxIndex, calcMethod, calcObject, agent, depNum, sDepName, sRekvisit);
        }

        /** Расчет суммы позиции. */
        String calcSum() {
            if ( ( sPrice != null ) && ( sQty != null ) ) {
                return CommonFunc.ValueRound(CommonFunc.ValuesMul(CommonFunc.ValueRound(sPrice,CommonFunc.CURRENCY_RADIX),sQty),CommonFunc.CURRENCY_RADIX);
            }
            return CommonFunc.CURRENCY_ZERO;
        }

        /**
         * Конверсия строки со сканера для замены конструкций вида \\u001d или №u001d на байт \x1D.
         * @param code штрихкод полученный со сканера.
         * @return штрихкод без макросов.
         */
        String convertKM(String code) {
            StringBuilder ret = new StringBuilder();
            int i = code.length();
            int pos = 0;

            while(pos < i) {
                if ( (code.charAt(pos) == '\\' || code.charAt(pos) == '№' ) &&
                        (pos+6 < i) &&
                        (code.charAt(pos + 1) == 'u' || code.charAt(pos + 1) == 'U') ) {
                    // укладываем преобразованный байт и меняем позицию чтения
                    pos += 4;
                    ret.append((char)(TMCommand.HexToByte(code.getBytes(), pos++) & 0xFF));
                }
                else {
                    ret.append(code.charAt(pos));
                }
                pos++;
            }
            return ret.toString();
        }
    }

    /** Настройки диалога. */
    public static final class sets{
        /** Имя пользователя. */
        static final String USER_NAME = "Receipt_UserName";
        /** ИНН пользователя. */
        static final String USER_INN = "Receipt_UserINN";
        /** Номер места. */
        static final String PLACE = "Receipt_Place";
        /** Номер столика. */
        static final String TABLE = "Receipt_Table";
        /** Счет. */
        static final String ACCOUNT = "Receipt_Account";
        /** Кол-во копий. */
        static final String COPIES = "Receipt_Copies";
        /** Тип налогообложения. */
        static final String TAX_SYSTEM = "Receipt_TaxSystem";
        /** Тип коррекции. */
        static final String CORR_TYPE = "Receipt_CorrType";
        /** Описание коррекции. */
        static final String CORR_DOCFP = "Receipt_CorrDocFP";
        /** Номер документа коррекции. */
        static final String CORR_DOCNUM = "Receipt_CorrDocNum";
        /** Наименование товара. */
        static final String GOOD_NAME = "Receipt_GoodName";
        /** Артикул товара. */
        static final String GOOD_CODE = "Receipt_GoodCode";
        /** Цена товара. */
        static final String GOOD_PRICE = "Receipt_GoodPrice";
        /** Кол-во товара. */
        static final String GOOD_QTY = "Receipt_GoodQty";
        /** Единица измрения товара. */
        static final String GOOD_UNIT = "Receipt_GoodUnit";
        /** Номер отдела. */
        static final String DEP_NUM = "Receipt_DepNum";
        /** Наименование отдела. */
        static final String DEP_NAME = "Receipt_DepName";
        /** Индекс налога. */
        static final String TAX_INDEX = "Receipt_TaxIndex";
        /** Предмет расчета. */
        static final String CALC_OBJECT = "Receipt_CalcObject";
        /** Метод расчета. */
        static final String CALC_METHOD = "Receipt_CalcMethod";
        /** Код товарной номенклатуры. */
        static final String BAR_CODE = "Receipt_BarCode";
        /** Метод расчета. */
        static final String AGENT = "Receipt_Agent";
        /** Телефон платежного агента (1073). */
        static final String TAG_1073 = "Receipt_Tag1073";
        /** Телефон оператора приема платежей (1074). */
        static final String TAG_1074 = "Receipt_Tag1074";
        /** Телефон оператора перевода (1075). */
        static final String TAG_1075 = "Receipt_Tag1075";
        /** Операция платежного агента (1044). */
        static final String TAG_1044 = "Receipt_Tag1044";
        /** Наименование оператора перевода (1026). */
        static final String TAG_1026 = "Receipt_Tag1026";
        /** Адрес оператора перевода (1005). */
        static final String TAG_1005 = "Receipt_Tag1005";
        /** ИНН оператора перевода (1016). */
        static final String TAG_1016 = "Receipt_Tag1016";
        /** ИНН поставщика (1226). */
        static final String TAG_1226 = "Receipt_Tag1226";
        /** Телефон поставщика (1171). */
        static final String TAG_1171 = "Receipt_Tag1171";
        /** Наименование поставщика (1225). */
        static final String TAG_1225 = "Receipt_Tag1225";
        /** Дополнительный реквизит предмета расчета. */
        static final String TAG_1191 = "Receipt_Tag1191";
        /** Место рассчетов. */
        static final String TAG_1187 = "Receipt_Tag1187";
        /** Вид оплаты. */
        static final String PAY_TYPE = "Receipt_PayType";
        /** Название карты оплаты. */
        static final String PAY_CARD_NAME = "Receipt_PayCardName";
        /** Индекс пользовательской оплаты. */
        static final String PAY_INDEX = "Receipt_PayIndex";
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_receipt);

        //создание хендлера
        if( h == null ) h = new ReceiptHandler(this);
        else h.SetActivity(this);

        //создание списка товара
        goodList = new ArrayList<>(64);

        //значения по умолчанию
        sReceiptTotal = CommonFunc.CURRENCY_ZERO;
        sReceiptRemaind = CommonFunc.CURRENCY_ZERO;
        currentGood = 0;

        //создание фрагментов
        fragmentOpen = FragmentOpen.newInstance(R.layout.fragment_receipt_open);
        fragmentAdd  = FragmentAdd.newInstance(R.layout.fragment_receipt_add);
        fragmentAgent  = FragmentAgent.newInstance(R.layout.fragment_receipt_agent);
        fragmentPay  = FragmentPay.newInstance(R.layout.fragment_receipt_pay);

        if (savedInstanceState == null) {
            // при первом запуске программы
            FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
            // добавляем в контейнер при помощи метода add()
            fragmentTransaction.add(R.id.receipt, fragmentOpen, TAG_OPEN);
            fragmentTransaction.commit();

            cheque = null;
        }
    }

    @Override
    protected void onStart() {
        super.onStart();

        //регистрация хендлера для получения ответов от контроллера ФН
        TMLib.getInstance().registerHandler(h);

        //получаем текущую дату
        final Calendar cal = Calendar.getInstance();
        docYear = cal.get(Calendar.YEAR);
        docMonth = cal.get(Calendar.MONTH);
        docDay = cal.get(Calendar.DAY_OF_MONTH);
        SetDateText(docDay, docMonth, docYear);

        //снимаем диалог если он есть
        if ( h.GetState()==TMOismHandler.states.NOT_ACTIVE ) dismissDlgValidateKM();
    }

    /** При позитивном завершении диалога (нажатие кнопки ОК). */
    public void onMessageBoxPositiveClick(DialogInterface dialog) {
        //завершаем активность
        if ( isExit ) {
            finish();
        }
    }

    /** При негативном завершении диалога (нажатие кнопки ОТМЕНА). */
    public void onMessageBoxNegativeClick(DialogInterface dialog) {
    }

    /** Обработка нажатия кнопки ОТМЕНА. */
    public void onButtonCancel(View view) {
        finish(); //завершение активности
    }

    /** Обработка нажатия кнопки ОТМЕНА ЧЕКА. */
    public void onButtonReceiptCancel(View view) {
        TMCommand cmd = new TMCommand();
        cmd.CmdReceiptCancel();
        TMLib.getInstance().DoCmd(this, cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Обработка нажатия кнопки ОТКРЫТЬ ЧЕК. */
    public void onButtonReceiptOpen(View view) {
        try {
            View v = getSupportFragmentManager().findFragmentByTag(TAG_OPEN).requireView();
            if (String.valueOf(((TextView) v.findViewById(R.id.fio_kassir)).getText()).isEmpty()) {
                MessageBox.Create(getString(R.string.header_warning), getString(R.string.msg_bad_field_cashier), MessageBox.option.OK).show(getSupportFragmentManager(), MessageBox.TAG);
            } else {
                //тормозим потоки отправки
                TMLib.getInstance().StopOFD();
                TMLib.getInstance().StopOISM();

                //создаем чек
                cheque = new Cheque(v);

                //запускаем процедуру определения есть ли у нас поддержка маркированного товара
                //в любом случае переходим к добавлению товара в чек
                TMOismHandler.CallBack cb = new TMOismHandler.CallBack() {
                    @Override
                    public void onOismError(String errText) {
                        //переходим к вводу товара
                        ffdVer = h.GetFFDVersion();
                        startAddGood();
                    }

                    @Override
                    public void onOismSuccess(boolean isTMT, TMOismHandler.Item item) {
                        //переходим к вводу товара
                        ffdVer = h.GetFFDVersion();
                        startAddGood();
                    }

                    @Override
                    public void onOismCancel() {
                        //переходим к вводу товара
                        ffdVer = h.GetFFDVersion();
                        startAddGood();
                    }
                };
                //запускаем процедуру
                h.StartCheck(this,cb);
            }
        }
        catch (Exception ignored) {
        }
    }

    /** Обработка нажатия кнопки ДОБАВИТЬ ТОВАР. */
    public void onButtonReceiptItem(View view) {
        try {
            View v = getSupportFragmentManager().findFragmentByTag(TAG_ADD).requireView();
            //добавляем товар в список
            goodList.add(new Good(v));

            //рассчет суммы
            sReceiptTotal = CommonFunc.CURRENCY_ZERO;
            for (Good g:goodList) {
                sReceiptTotal = CommonFunc.ValuesAdd(sReceiptTotal,g.calcSum());
            }
            ((TextView)v.findViewById(R.id.receipt_sum)).setText(sReceiptTotal);
        }
        catch (Exception ignored){
        }
    }

    /** Обработка нажатия кнопки РЕКВИЗИТЫ АГЕНТА. */
    public void onButtonReceiptAgent(View view) {
        //переходим к вводу реквизитов
        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
        //fragmentTransaction.addToBackStack(null);
        fragmentTransaction.add(R.id.receipt, fragmentAgent, TAG_AGENT);
        fragmentTransaction.hide(fragmentAdd);
        fragmentTransaction.commit();
    }

    /** Обработка нажатия кнопки ОТМЕНА в АГЕНТЕ. */
    public void onButtonReceiptAgentCancel(View view) {
        //возвращаем фрагмент ввода товара
        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
        fragmentTransaction.show(fragmentAdd);
        fragmentTransaction.remove(fragmentAgent);
        fragmentTransaction.commit();
    }

    /** Обработка нажатия кнопки УСТАНОВИТЬ РЕКВИЗИТЫ в АГЕНТЕ. */
    public void onButtonReceiptAgentSet(View view) {
        try {
            View v = getSupportFragmentManager().findFragmentByTag(TAG_AGENT).requireView();
            sTag1073 = String.valueOf(((TextView) v.findViewById(R.id.tag_1073)).getText());
            sTag1074 = String.valueOf(((TextView) v.findViewById(R.id.tag_1074)).getText());
            sTag1075 = String.valueOf(((TextView) v.findViewById(R.id.tag_1075)).getText());
            sTag1044 = String.valueOf(((TextView) v.findViewById(R.id.tag_1044)).getText());
            sTag1026 = String.valueOf(((TextView) v.findViewById(R.id.tag_1026)).getText());
            sTag1005 = String.valueOf(((TextView) v.findViewById(R.id.tag_1005)).getText());
            sTag1016 = String.valueOf(((TextView) v.findViewById(R.id.tag_1016)).getText());
            sTag1226 = String.valueOf(((TextView) v.findViewById(R.id.tag_1226)).getText());
            sTag1171 = String.valueOf(((TextView) v.findViewById(R.id.tag_1171)).getText());
            sTag1225 = String.valueOf(((TextView) v.findViewById(R.id.tag_1225)).getText());

            //возвращаем фрагмент ввода товара
            FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
            fragmentTransaction.show(fragmentAdd);
            fragmentTransaction.remove(fragmentAgent);
            //fragmentTransaction.add(R.id.receipt, fragmentAgent, TAG_AGENT);
            fragmentTransaction.commit();
        }
        catch (Exception ignored) {
        }
    }

    /** Обработка нажатия кнопки ПРИЕМ ОПЛАТЫ. */
    public void onButtonReceiptPay(View view) {
        try {
            View v = getSupportFragmentManager().findFragmentByTag(TAG_PAY).requireView();
            String sum = String.valueOf(((TextView) v.findViewById(R.id.pay_sum)).getText());
            String add = String.valueOf(((TextView) v.findViewById(R.id.pay_card_name)).getText());
            String comment = String.valueOf(((TextView) v.findViewById(R.id.pay_comment)).getText());
            byte payType = ((RadioButton) v.findViewById(R.id.pay_type_cash)).isChecked() ? TMCommand.pay_indexes.CASH : ((RadioButton) v.findViewById(R.id.pay_type_card)).isChecked() ? TMCommand.pay_indexes.CARD : ((RadioButton) v.findViewById(R.id.pay_type_advance)).isChecked() ? TMCommand.pay_indexes.ADVANCE : ((RadioButton) v.findViewById(R.id.pay_type_credit)).isChecked() ? TMCommand.pay_indexes.CREDIT : ((RadioButton) v.findViewById(R.id.pay_type_other)).isChecked() ? TMCommand.pay_indexes.OTHER : Byte.parseByte(String.valueOf(v.findViewById(R.id.pay_user)));
            if (((CheckBox) v.findViewById(R.id.flag_round)).isChecked()) payType |= TMCommand.pay_indexes.FLAG_ROUND;
            h.DoCmdReceiptTender(payType, sum, add, comment);
        }
        catch (Exception ignored) {
        }
    }

    /** Обработка нажатия кнопки ЗАКРЫТЬ ЧЕК. */
    public void onButtonReceiptClose(View view) {
        h.DoCmdReceiptClose();
    }

    /** Обработка нажатия кнопки ПЕРЕЙТИ К ОПЛАТЕ. */
    public void onButtonReceiptTotal(View view) {
        //начинаем валидацию товара
        currentGood = 0;
        validateKM();
    }

    /**
     * Вывод блокирующего диалога при проверке товара в ОИСМ.
     * @param goodName наименование товара.
     */
    private void viewDlgValidateKM(String goodName) {
        //создаем и выводим диалог
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(getString(R.string.header_validate_km));
        builder.setMessage(getString(R.string.msg_validate_item) + "\n\n" + goodName);
        dlgValidateKM = builder.create(); //установка текста
        dlgValidateKM.setCancelable(false); //игнорирование клавиши возврат
        dlgValidateKM.setCanceledOnTouchOutside(false); //игнорирование тычков за пределами диалога
        dlgValidateKM.show();
    }

    /**
     * Убираем блокирующий диалог.
     */
    private void dismissDlgValidateKM() {
        if ( dlgValidateKM != null ) {
            try{
                dlgValidateKM.dismiss();
                dlgValidateKM = null;
            }
            catch(Exception ignored) {}
        }
    }

    /** Валидация кодов маркировки. */
    public void validateKM() {
        //если поддерживается маркировка по ФФД 1.2 и есть маркированный товар
        //то необходимо проверить коды маркировки в ОИСМ
        if ( h.IsTMT() && (currentGood < goodList.size()) ) {

            //проверяем наличие кода маркировки
            String code = goodList.get(currentGood).getBarCode();

            int markType;

            if( (code != null) && (!code.isEmpty()) ) {
                markType = TMMarkCode.Validate(code, true);
            }
            else
            {
                markType = -1;
            }

            if( ( markType == TMMarkCode.prefix1162.GS1_DM) || ( markType == TMMarkCode.prefix1162.UNKNOWN)
                    || ( markType == TMMarkCode.prefix1162.EAN_8) || ( markType == TMMarkCode.prefix1162.EAN_13)
                    || ( markType == TMMarkCode.prefix1162.ITF_14)) {
                //маркировку нужно проверять в ОИСМ

                if( ( markType == TMMarkCode.prefix1162.EAN_8) || ( markType == TMMarkCode.prefix1162.EAN_13)
                        || ( markType == TMMarkCode.prefix1162.ITF_14) ){
                    goodList.get(currentGood).setIsCheckOISM(false);
                }

                TMOismHandler.CallBack cb = new TMOismHandler.CallBack() {
                    @Override
                    public void onOismError(String errText) {
                        //снимаем диалог
                        dismissDlgValidateKM();

                        //сообщение об ошибке
                        MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_validate_fail) + "\n\n" + errText, MessageBox.option.OK | MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
                    }

                    @Override
                    public void onOismSuccess(boolean isTMT, TMOismHandler.Item item) {
                        isKM = true; //потребуется отправить в ОИСМ

                        //снимаем диалог
                        dismissDlgValidateKM();

                        if ( (item.statusKM&0x10) == 0x00 && goodList.get(currentGood).getIsCheckInOISM() && ((item.statusKM&0x0F) != 0x0F ) ) {
                            //только для кодов проверяемых онлайн в ОИСМ: код маркировки не прошел полностью проверку
                            MessageBox.CallBack mcb = new MessageBox.CallBack() {
                                @Override
                                public void onMessageBoxPositiveClick(DialogInterface dialog) {
                                    //удаляем товар из списка
                                    goodList.remove(currentGood);
                                    validateKM();
                                }

                                @Override
                                public void onMessageBoxNegativeClick(DialogInterface dialog) {
                                    //сохраняем статусы проверки кода маркировки
                                    goodList.get(currentGood).setStatusKM(item);

                                    //продолжаем валидацию
                                    currentGood++;
                                    validateKM();
                                }
                            };

                            MessageBox.Create(getString(R.string.header_warning), getString(R.string.msg_no_validate_km)+"\n"+goodList.get(currentGood).getName()+"\n\n" + getString(R.string.msg_remove_receipt_item), MessageBox.option.OK|MessageBox.option.CANCEL|MessageBox.option.YES_NO , mcb).show(getSupportFragmentManager(), MessageBox.TAG);
                        }
                        else {
                            //код маркировки проверен успешно

                            //сохраняем статусы проверки кода маркировки
                            goodList.get(currentGood).setStatusKM(item);

                            //продолжаем валидацию
                            currentGood++;
                            validateKM();
                        }
                    }

                    @Override
                    public void onOismCancel() {
                        //снимаем диалог
                        dismissDlgValidateKM();

                        //продолжаем двигаться по списку товара
                        currentGood++;
                        validateKM();
                    }
                };

                //вывод диалога
                viewDlgValidateKM(goodList.get(currentGood).getName());
                //валидация маркировки в ОИСМ
                h.StartValidate(null, cb, cheque.type, goodList.get(currentGood).getForValidate(),goodList.get(currentGood).getIsCheckInOISM());

            }
            else {
                //продолжаем двигаться по списку товара
                currentGood++;
                validateKM();
            }
        }
        else {
            // успешно проверили весь товар - начинаем создание чека
            if (goodList.isEmpty()) {
                //в чек не добавлено ни одного товара
                MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_no_goods), MessageBox.option.OK | MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
            }
            else {
                // началось создание чека
                h.DoCmdGetDateTime();
            }
        }
    }

    /** Переходим к вводу товара. */
    public void startAddGood() {
        FragmentTransaction fragmentTransaction = getSupportFragmentManager().beginTransaction();
        fragmentTransaction.replace(R.id.receipt, fragmentAdd, TAG_ADD);
        fragmentTransaction.commit();
    }

    /** Вывод диалога РАСЧЕТ. */
    public void viewTotalDialog() {
        //установка вида диалога
        LayoutInflater li = LayoutInflater.from(this);
        View dialogView = li.inflate(R.layout.dialog_receipt_total, null);

        //создаем AlertDialog
        AlertDialog.Builder mDialogBuilder = new AlertDialog.Builder(this);

        //привязка вида диалога к AlertDialog:
        mDialogBuilder.setView(dialogView);

        //Настраиваем отображение поля для ввода текста в открытом диалоге:
        final EditText userInput = dialogView.findViewById(R.id.input_text);

        //настраиваем диалог:
        mDialogBuilder
                .setCancelable(false)
                .setTitle(getString(R.string.header_receipt_total))
                .setPositiveButton(getString(R.string.btn_ok),
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog,int id) {
                                //получаем введенные строки
                                h.DoCmdReceiptTotal(String.valueOf(userInput.getText()));
                            }
                        })
                .setNegativeButton(getString(R.string.btn_cancel),
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog,int id) {
                                dialog.cancel();
                            }
                        });

        //вывод диалога
        mDialogBuilder.create().show();
    }

    /** Нажатие на поле "дата документа". */
    public void onClickDate(View v) {
        // вызываем диалог с выбором времени
        callDatePicker();
    }

    /** Установка даты документа коррекции. */
    public void SetDateText(int day, int month, int year) {
        TextView editDateTag1178 = findViewById(R.id.dateTag1178);
        if ( editDateTag1178 != null ) editDateTag1178.setText(String.format("%02d.%02d.%04d",day,month+1,year));
    }

    /** Вывод диалога выбора даты. */
    private void callDatePicker() {
        // инициализируем диалог выбора даты текущими значениями
        DatePickerDialog datePickerDialog = new DatePickerDialog(this,
                (view, year, month, day) -> {
                    docYear = year;
                    docMonth = month;
                    docDay = day;
                    SetDateText(docDay, docMonth, docYear);
                }, docYear, docMonth, docDay);
        datePickerDialog.show();
    }

    /** Класс-шаблон для фрагментов. */
    private static class FragmentReceipt extends Fragment {
        protected int resId;

        public FragmentReceipt() {
        }

        /**
         * Для восстановления состояния при повороте.
         * @param savedInstanceState пакет.
         */
        @Override
        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);

            if ( savedInstanceState != null) {
                if (savedInstanceState.containsKey("resId")) resId = savedInstanceState.getInt("resId");
            }
        }

        /**
         * Для сохранения текста при повороте.
         * @param outState пакет.
         */
        @Override
        public void onSaveInstanceState(@NonNull Bundle outState) {
            //сохранение данных
            outState.putInt("resId",resId);

            super.onSaveInstanceState(outState);
        }
    }

    /** Класс для создания фрагмента ОТКРЫТИЕ ЧЕКА. */
    public static class FragmentOpen extends FragmentReceipt {
        public FragmentOpen() {
        }

        public static FragmentOpen newInstance(int ResId) {
            FragmentOpen fragment = new FragmentOpen();
            fragment.resId = ResId;
            return fragment;
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            // Inflate the layout for this fragment
            View v = inflater.inflate(resId, null);

            try {
                //заполнение данными
                ((TextView) v.findViewById(R.id.fio_kassir)).setText(MainApp.settings.getString(sets.USER_NAME, ""));
                ((TextView) v.findViewById(R.id.inn_kassir)).setText(MainApp.settings.getString(sets.USER_INN, ""));
                ((TextView) v.findViewById(R.id.num_table)).setText(MainApp.settings.getString(sets.TABLE, ""));
                ((TextView) v.findViewById(R.id.num_place)).setText(MainApp.settings.getString(sets.PLACE, ""));
                ((TextView) v.findViewById(R.id.account)).setText(MainApp.settings.getString(sets.ACCOUNT, ""));
                ((TextView) v.findViewById(R.id.copies)).setText(MainApp.settings.getString(sets.COPIES, "1"));
                ((TextView) v.findViewById(R.id.editTag1187)).setText(MainApp.settings.getString(sets.TAG_1187, ""));
                ((TextView) v.findViewById(R.id.editCorrTag1179)).setText(MainApp.settings.getString(sets.CORR_DOCNUM, ""));
                ((TextView) v.findViewById(R.id.editCorrTag1192)).setText(MainApp.settings.getString(sets.CORR_DOCFP, ""));
                byte taxSystem = (byte) MainApp.settings.getInt(sets.TAX_SYSTEM, 0);
                Spinner spinnerTaxSystem = v.findViewById(R.id.tax_system);
                if (taxSystem < spinnerTaxSystem.getCount()) spinnerTaxSystem.setSelection(taxSystem);
                byte corrType = (byte) MainApp.settings.getInt(sets.CORR_TYPE, 0);
                Spinner spinnerCorrType = v.findViewById(R.id.correction_type);
                if (corrType < spinnerCorrType.getCount()) spinnerCorrType.setSelection(corrType);
            }
            catch(Exception ignored){}

            //Аннулирование чека
            TMCommand cmd = new TMCommand();
            cmd.CmdReceiptCancel();
            TMLib.getInstance().DoCmd(getContext(), cmd, CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));

            return v;
        }

        @Override
        public void onDestroyView() {
            try {
                //сохранение данных
                View v = requireView();
                SharedPreferences.Editor editor = MainApp.settings.edit();
                editor.putString(sets.USER_NAME, String.valueOf(((TextView) v.findViewById(R.id.fio_kassir)).getText()));
                editor.putString(sets.USER_INN, String.valueOf(((TextView) v.findViewById(R.id.inn_kassir)).getText()));
                editor.putString(sets.TABLE, String.valueOf(((TextView) v.findViewById(R.id.num_table)).getText()));
                editor.putString(sets.PLACE, String.valueOf(((TextView) v.findViewById(R.id.num_place)).getText()));
                editor.putString(sets.COPIES, String.valueOf(((TextView) v.findViewById(R.id.copies)).getText()));
                editor.putString(sets.TAG_1187, String.valueOf(((TextView) v.findViewById(R.id.editTag1187)).getText()));
                editor.putString(sets.CORR_DOCNUM, String.valueOf(((TextView) v.findViewById(R.id.editCorrTag1179)).getText()));
                editor.putString(sets.CORR_DOCFP, String.valueOf(((TextView) v.findViewById(R.id.editCorrTag1192)).getText()));
                byte taxSystem = (byte) (((Spinner) v.findViewById(R.id.tax_system)).getSelectedItemPosition());
                editor.putInt(sets.TAX_SYSTEM, 0xFF & (int) taxSystem);
                byte corrType = (byte) (((Spinner) v.findViewById(R.id.correction_type)).getSelectedItemPosition());
                editor.putInt(sets.CORR_TYPE, 0xFF & (int) corrType);
                editor.apply();
            }
            catch(Exception ignored){}

            super.onDestroyView();
        }
    }

    /** Класс для создания фрагмента ДОБАВИТЬ ТОВАР. */
    public static class FragmentAdd extends FragmentReceipt{
        /** Для получение ответа от сканера. */
        private final ActivityResultLauncher<ScanOptions> barcodeLauncher = registerForActivityResult(new ScanContract(),
                result -> {
                    if(result.getContents() == null) {
                        Intent originalIntent = result.getOriginalIntent();
                        if (originalIntent == null) {
                            //Log.d("MainActivity", "Cancelled scan");
                            Toast.makeText(MainApp.GetCtx(), "Cancelled", Toast.LENGTH_LONG).show();
                        } else if(originalIntent.hasExtra(Intents.Scan.MISSING_CAMERA_PERMISSION)) {
                            //Log.d("MainActivity", "Cancelled scan due to missing camera permission");
                            Toast.makeText(MainApp.GetCtx(), "Cancelled due to missing camera permission", Toast.LENGTH_LONG).show();
                        }
                    } else {
                        //Log.d("MainActivity", "Scanned");
                        Toast.makeText(MainApp.GetCtx(), "Scanned: " + result.getContents(), Toast.LENGTH_LONG).show();
                        View v = requireView();
                        ((TextView)v.findViewById(R.id.bar_code)).setText(result.getContents());
                    }
                });

        public FragmentAdd() {
        }

        public static FragmentAdd newInstance(int ResId) {
            FragmentAdd fragment = new FragmentAdd();
            fragment.resId = ResId;
            return fragment;
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            // Inflate the layout for this fragment
            View v = inflater.inflate(resId, null);

            if ( ffdVer < TMCommand.proto_ffd.FFD_1_2 ) {
                try {
                    //укороченный список признаков предмета рассчета для ФФД 1.1 и 1.05
                    ArrayAdapter<CharSequence> aa = ArrayAdapter.createFromResource(this.requireContext(), R.array.calc_objects_ffd11, android.R.layout.simple_spinner_item);
                    aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                    ((Spinner) v.findViewById(R.id.calc_object)).setAdapter(aa);
                }
                catch(Exception ignored){}
            }

            try {
                //заполнение данными
                ((TextView) v.findViewById(R.id.receipt_sum)).setText(sReceiptTotal);
                ((TextView) v.findViewById(R.id.good_name)).setText(MainApp.settings.getString(sets.GOOD_NAME, "Товар"));
                ((TextView) v.findViewById(R.id.good_code)).setText(MainApp.settings.getString(sets.GOOD_CODE, ""));
                ((TextView) v.findViewById(R.id.good_price)).setText(MainApp.settings.getString(sets.GOOD_PRICE, "1.00"));
                ((TextView) v.findViewById(R.id.good_qty)).setText(MainApp.settings.getString(sets.GOOD_QTY, "1"));
                ((TextView) v.findViewById(R.id.good_unit)).setText(MainApp.settings.getString(sets.GOOD_UNIT, "шт."));
                ((TextView) v.findViewById(R.id.bar_code)).setText(MainApp.settings.getString(sets.BAR_CODE, ""));
                ((TextView) v.findViewById(R.id.dep_num)).setText(MainApp.settings.getString(sets.DEP_NUM, "1"));
                ((TextView) v.findViewById(R.id.dep_name)).setText(MainApp.settings.getString(sets.DEP_NAME, "ТОВАРЫ И УСЛУГИ"));

                //налоговая ставка
                byte taxIndex = (byte) MainApp.settings.getInt(sets.TAX_INDEX, TMCommand.tax_indexes.NDS_20);
                Spinner spinnerTaxIndex = v.findViewById(R.id.tax_index);
                if (taxIndex < spinnerTaxIndex.getCount()) spinnerTaxIndex.setSelection(taxIndex);

                //признак метода рассчета
                byte calcMethod = (byte) MainApp.settings.getInt(sets.CALC_METHOD, TMCommand.calc_methods.FULL_PAYMENT-1);
                Spinner spinnerCalcMethod = v.findViewById(R.id.calc_method);
                if (calcMethod < spinnerCalcMethod.getCount()) spinnerCalcMethod.setSelection(calcMethod);

                //признак предмета рассчета
                byte calcObject = (byte) MainApp.settings.getInt(sets.CALC_OBJECT, TMCommand.calc_objects.GOOD-1);
                Spinner spinnerCalcObject = v.findViewById(R.id.calc_object);
                if (calcObject < spinnerCalcObject.getCount()) spinnerCalcObject.setSelection(calcObject);

                //агенты
                byte agent = (byte) MainApp.settings.getInt(sets.AGENT, 0);
                ((CheckBox) v.findViewById(R.id.bank_agent)).setChecked((agent & TMCommand.agent_type.BANK_PAY_AGENT) != 0);
                ((CheckBox) v.findViewById(R.id.bank_subagent)).setChecked((agent & TMCommand.agent_type.BANK_PAY_SUBAGENT) != 0);
                ((CheckBox) v.findViewById(R.id.pay_agent)).setChecked((agent & TMCommand.agent_type.PAY_AGENT) != 0);
                ((CheckBox) v.findViewById(R.id.pay_subagent)).setChecked((agent & TMCommand.agent_type.PAY_SUBAGENT) != 0);
                ((CheckBox) v.findViewById(R.id.confidant)).setChecked((agent & TMCommand.agent_type.CONFIDANT) != 0);
                ((CheckBox) v.findViewById(R.id.broker)).setChecked((agent & TMCommand.agent_type.BROKER) != 0);
                ((CheckBox) v.findViewById(R.id.agent_other)).setChecked((agent & TMCommand.agent_type.OTHER) != 0);
                ((TextView) v.findViewById(R.id.tag_1191)).setText(MainApp.settings.getString(sets.TAG_1191, ""));

                // доступность чекбокса зависит от состояния битов 14 15 16 в теге 1290,
                // а также признака автономного режима
                // по умолчанию проверка включена, для автономки - выключена
                // при выключенной проверке пропускаются команды 0х24 и 0х25 (в ФН 0xB5 и 0xB6)
                ((CheckBox)v.findViewById(R.id.bar_code_oism_check)).setChecked(!h.IsAutonom());
                v.findViewById(R.id.bar_code_oism_check).setEnabled( h.isEXTRegBits() && ( !h.IsAutonom() ) );

                if ( ffdVer < TMCommand.proto_ffd.FFD_1_2 ) {
                    //размер упаковки не учитывается
                    v.findViewById(R.id.lot_size_name).setEnabled(false);
                    v.findViewById(R.id.lot_size).setEnabled(false);
                }

                if ( ffdVer >= TMCommand.proto_ffd.FFD_1_2 ) {
                    //для ФФД версии ввод единиц измерения через выпадающее меню
                    final EditText unitView = v.findViewById(R.id.good_unit);
                    unitView.setFocusable(false);
                    unitView.setInputType(InputType.TYPE_NULL);
                    unitView.setText("0");

                    //выпадающее меню
                    unitView.setOnClickListener(vv -> {
                        PopupMenu popupMenu = new PopupMenu(requireContext(), unitView);
                        popupMenu.inflate(R.menu.menu_receipt_good_unit);

                        popupMenu.setOnMenuItemClickListener(item -> {
                            String name = String.valueOf(item.getTitle());
                            int i = name.indexOf(' ');
                            if ( (i != 0) && (i < 4) ){
                                unitView.setText(name.substring(0,i));
                                return true;
                            }
                            return false;
                        });

                        popupMenu.show();
                    });
                }

                //кнопка для сканирования маркировки
	            v.findViewById(R.id.scanBarCodeButton).setOnClickListener(new View.OnClickListener() {
	                @Override
	                public void onClick(View v) {
	                    //запускаем сканирование
	                    barcodeLauncher.launch(new ScanOptions());
	                }
	            });

            }
            catch(Exception ignored) {}

            //Log.d("onCreateView",this.toString());

            return v;
        }

        @Override
        public void onDestroyView() {
            //сохранение данных
            try {
                View v = requireView();
                SharedPreferences.Editor editor = MainApp.settings.edit();

                //параметры товара
                editor.putString(sets.GOOD_NAME, String.valueOf(((TextView) v.findViewById(R.id.good_name)).getText()));
                editor.putString(sets.GOOD_CODE, String.valueOf(((TextView) v.findViewById(R.id.good_code)).getText()));
                editor.putString(sets.GOOD_PRICE, String.valueOf(((TextView) v.findViewById(R.id.good_price)).getText()));
                editor.putString(sets.GOOD_QTY, String.valueOf(((TextView) v.findViewById(R.id.good_qty)).getText()));
                editor.putString(sets.GOOD_UNIT, String.valueOf(((TextView) v.findViewById(R.id.good_unit)).getText()));
                editor.putString(sets.BAR_CODE, String.valueOf(((TextView) v.findViewById(R.id.bar_code)).getText()));
                editor.putString(sets.DEP_NUM, String.valueOf(((TextView) v.findViewById(R.id.dep_num)).getText()));
                editor.putString(sets.DEP_NAME, String.valueOf(((TextView) v.findViewById(R.id.dep_name)).getText()));

                //индекс налога
                byte taxIndex = (byte) ((Spinner) v.findViewById(R.id.tax_index)).getSelectedItemPosition();
                editor.putInt(sets.TAX_INDEX, 0xFF & taxIndex);

                //признак метода рассчета
                byte calcMethod = (byte) ((Spinner) v.findViewById(R.id.calc_method)).getSelectedItemPosition();
                editor.putInt(sets.CALC_METHOD, 0xFF & calcMethod);

                //признак предмета рассчета
                byte calcObject = (byte) ((Spinner) v.findViewById(R.id.calc_object)).getSelectedItemPosition();
                editor.putInt(sets.CALC_OBJECT, 0xFF & calcObject);

                //признак агента
                byte agent = 0;
                if (((CheckBox) v.findViewById(R.id.bank_agent)).isChecked()) agent |= TMCommand.agent_type.BANK_PAY_AGENT;
                if (((CheckBox) v.findViewById(R.id.bank_subagent)).isChecked()) agent |= TMCommand.agent_type.BANK_PAY_SUBAGENT;
                if (((CheckBox) v.findViewById(R.id.pay_agent)).isChecked()) agent |= TMCommand.agent_type.PAY_AGENT;
                if (((CheckBox) v.findViewById(R.id.pay_subagent)).isChecked()) agent |= TMCommand.agent_type.PAY_SUBAGENT;
                if (((CheckBox) v.findViewById(R.id.confidant)).isChecked()) agent |= TMCommand.agent_type.CONFIDANT;
                if (((CheckBox) v.findViewById(R.id.broker)).isChecked()) agent |= TMCommand.agent_type.BROKER;
                if (((CheckBox) v.findViewById(R.id.agent_other)).isChecked()) agent |= TMCommand.agent_type.OTHER;
                editor.putInt(sets.AGENT, 0xFF & agent);

                //дополнительные теги
                editor.putString(sets.TAG_1191, String.valueOf(((TextView) v.findViewById(R.id.tag_1191)).getText()));

                //сохранение параметров
                editor.apply();
            }
            catch(Exception ignored) {}

            super.onDestroyView();
        }
    }

    /**
     * Генерация изображения QR кода.
     * @param data строка данных.
     * @return изображение.
     */
    Bitmap MakeQR(String data) {
        try {
            Map<EncodeHintType, Object> hints = new HashMap<>();
            hints.put(EncodeHintType.MARGIN, 0); //без зазоров
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");

            //создание матрицы кода
            BitMatrix mQRcode = new QRCodeWriter().encode(data, BarcodeFormat.QR_CODE, 0, 0, hints);
            int w = mQRcode.getWidth();
            int h = mQRcode.getHeight();

            //конвертация в набор пикселей
            int[] pixels = new int[w * h];

            //генерация картинки
            for (int y = 0; y < h; y++) {
                for (int x = 0; x < w; x++) {
                    pixels[y * w + x] = (mQRcode.get(x, y))?0xff000000:0xffffffff;
                }
            }

            //Generate the format of the QR code image, use ARGB_8888
            Bitmap bitmap = Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, w, 0, 0, w, h);

            return bitmap;
        }
        catch(Exception ex){
            MessageBox.Create(getString(R.string.header_success), getString(R.string.msg_cmd_success) + "\n\nЗАБЕРИТЕ ЧЕК", MessageBox.option.OK).show(getSupportFragmentManager(), MessageBox.TAG);
        }
        return null;
    }


    private void dialogViewReceipt(String qr, int fd, int fp) {
        //генерация QR кода
        if ( qr.startsWith("<QR>") ) qr = qr.substring(4);
        if ( qr.endsWith("</QR>") ) qr = qr.substring(0,qr.length()-5);
        Bitmap qrImage = MakeQR(qr);

        if ( qrImage != null ) {
            //установка вида диалога
            LayoutInflater li = LayoutInflater.from(this);
            View dialogView = li.inflate(R.layout.dialog_view_receipt, null);

            //создаем AlertDialog
            AlertDialog.Builder mDialogBuilder = new AlertDialog.Builder(this);

            //привязка вида диалога к AlertDialog:
            mDialogBuilder.setView(dialogView);

            //Настраиваем отображение поля для ввода текста в открытом диалоге:
            final ImageView qrImageView = dialogView.findViewById(R.id.viewReceiptImage);
            final TextView fdText = dialogView.findViewById(R.id.dlgViewReceiptFD);
            final TextView fpText = dialogView.findViewById(R.id.dlgViewReceiptFP);

            //TODO подогнать под размер экрана
            qrImageView.setImageBitmap(Bitmap.createScaledBitmap(qrImage,qrImage.getWidth()*5,qrImage.getHeight()*5,false));
            fdText.setText(Long.toString(0xFFFFFFFFL&(long)fd));
            fpText.setText(Long.toString(0xFFFFFFFFL&(long)fp));

            //настраиваем диалог:
            mDialogBuilder.setCancelable(false).setTitle(getString(R.string.header_receipt_close)).setPositiveButton(getString(R.string.btn_ok), (dialog, id) -> finish());

            //вывод диалога
            mDialogBuilder.create().show();
        }
    }

    /** Класс для создания фрагмента ПРИЕМ ОПЛАТЫ. */
    public static class FragmentPay extends FragmentReceipt {
        public FragmentPay() {
        }

        public static FragmentPay newInstance(int ResId) {
            FragmentPay fragment = new FragmentPay();
            fragment.resId = ResId;
            return fragment;
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            // Inflate the layout for this fragment

            View v = inflater.inflate(resId, null);

            try {
                //заполнение данными
                ((TextView) v.findViewById(R.id.receipt_total)).setText(sReceiptTotal);
                ((TextView) v.findViewById(R.id.receipt_remaind)).setText(sReceiptRemaind);
                ((TextView) v.findViewById(R.id.pay_sum)).setText(sReceiptRemaind);
                ((TextView) v.findViewById(R.id.pay_card_name)).setText(MainApp.settings.getString(sets.PAY_CARD_NAME, ""));
                ((TextView) v.findViewById(R.id.pay_user)).setText(MainApp.settings.getString(sets.PAY_INDEX, "5"));

                byte payType = (byte) MainApp.settings.getInt(sets.PAY_TYPE, 0);
                switch (payType) {
                    case TMCommand.pay_indexes.CASH:
                        ((RadioButton) v.findViewById(R.id.pay_type_cash)).setChecked(true);
                        break;
                    case TMCommand.pay_indexes.CARD:
                        ((RadioButton) v.findViewById(R.id.pay_type_card)).setChecked(true);
                        break;
                    case TMCommand.pay_indexes.ADVANCE:
                        ((RadioButton) v.findViewById(R.id.pay_type_advance)).setChecked(true);
                        break;
                    case TMCommand.pay_indexes.CREDIT:
                        ((RadioButton) v.findViewById(R.id.pay_type_credit)).setChecked(true);
                        break;
                    case TMCommand.pay_indexes.OTHER:
                        ((RadioButton) v.findViewById(R.id.pay_type_other)).setChecked(true);
                        break;
                    default:
                        ((RadioButton) v.findViewById(R.id.pay_type_user)).setChecked(true);
                        break;
                }
            }
            catch(Exception ignored) {}

            return v;
        }

        @Override
        public void onDestroyView() {
            try {
                //сохранение данных
                View v = getView();

                SharedPreferences.Editor editor = MainApp.settings.edit();
                editor.putString(sets.PAY_CARD_NAME, String.valueOf(((TextView) v.findViewById(R.id.pay_card_name)).getText()));
                editor.putString(sets.PAY_INDEX, String.valueOf(((TextView) v.findViewById(R.id.pay_user)).getText()));
                byte payType = ((RadioButton) v.findViewById(R.id.pay_type_cash)).isChecked() ? TMCommand.pay_indexes.CASH : ((RadioButton) v.findViewById(R.id.pay_type_card)).isChecked() ? TMCommand.pay_indexes.CARD : ((RadioButton) v.findViewById(R.id.pay_type_advance)).isChecked() ? TMCommand.pay_indexes.ADVANCE : ((RadioButton) v.findViewById(R.id.pay_type_credit)).isChecked() ? TMCommand.pay_indexes.CREDIT : ((RadioButton) v.findViewById(R.id.pay_type_other)).isChecked() ? TMCommand.pay_indexes.OTHER : TMCommand.pay_indexes.USER;
                editor.putInt(sets.PAY_TYPE, payType);
                editor.apply();
            }
            catch(Exception ignored) {}

            super.onDestroyView();
        }
    }

    /** Класс для создания фрагмента ПРИЕМ ОПЛАТЫ. */
    public static class FragmentAgent extends FragmentReceipt {
        public FragmentAgent() {
        }

        public static FragmentAgent newInstance(int ResId) {
            FragmentAgent fragment = new FragmentAgent();
            fragment.resId = ResId;
            return fragment;
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            // Inflate the layout for this fragment
            View v = inflater.inflate(resId, null);

            try {
                //заполнение данными
                ((TextView) v.findViewById(R.id.tag_1073)).setText(MainApp.settings.getString(sets.TAG_1073, ""));
                ((TextView) v.findViewById(R.id.tag_1074)).setText(MainApp.settings.getString(sets.TAG_1074, ""));
                ((TextView) v.findViewById(R.id.tag_1075)).setText(MainApp.settings.getString(sets.TAG_1075, ""));
                ((TextView) v.findViewById(R.id.tag_1044)).setText(MainApp.settings.getString(sets.TAG_1044, ""));
                ((TextView) v.findViewById(R.id.tag_1026)).setText(MainApp.settings.getString(sets.TAG_1026, ""));
                ((TextView) v.findViewById(R.id.tag_1005)).setText(MainApp.settings.getString(sets.TAG_1005, ""));
                ((TextView) v.findViewById(R.id.tag_1016)).setText(MainApp.settings.getString(sets.TAG_1016, ""));
                ((TextView) v.findViewById(R.id.tag_1226)).setText(MainApp.settings.getString(sets.TAG_1226, ""));
                ((TextView) v.findViewById(R.id.tag_1171)).setText(MainApp.settings.getString(sets.TAG_1171, ""));
                ((TextView) v.findViewById(R.id.tag_1225)).setText(MainApp.settings.getString(sets.TAG_1225, ""));
            }
            catch(Exception ignored){}

            return v;
        }

        @Override
        public void onDestroyView() {
            try {
                //сохранение данных
                View v = getView();
                SharedPreferences.Editor editor = MainApp.settings.edit();
                editor.putString(sets.TAG_1073, String.valueOf(((TextView) v.findViewById(R.id.tag_1073)).getText()));
                editor.putString(sets.TAG_1074, String.valueOf(((TextView) v.findViewById(R.id.tag_1074)).getText()));
                editor.putString(sets.TAG_1075, String.valueOf(((TextView) v.findViewById(R.id.tag_1075)).getText()));
                editor.putString(sets.TAG_1044, String.valueOf(((TextView) v.findViewById(R.id.tag_1044)).getText()));
                editor.putString(sets.TAG_1026, String.valueOf(((TextView) v.findViewById(R.id.tag_1026)).getText()));
                editor.putString(sets.TAG_1005, String.valueOf(((TextView) v.findViewById(R.id.tag_1005)).getText()));
                editor.putString(sets.TAG_1016, String.valueOf(((TextView) v.findViewById(R.id.tag_1016)).getText()));
                editor.putString(sets.TAG_1226, String.valueOf(((TextView) v.findViewById(R.id.tag_1226)).getText()));
                editor.putString(sets.TAG_1171, String.valueOf(((TextView) v.findViewById(R.id.tag_1171)).getText()));
                editor.putString(sets.TAG_1225, String.valueOf(((TextView) v.findViewById(R.id.tag_1225)).getText()));
                editor.apply();
            }
            catch (Exception ignored){}

            super.onDestroyView();
        }
    }

    /** Хендлер для обработки сообщений от TMLib. */
    private static class ReceiptHandler extends TMOismHandler {
        private ReceiptActivity activity;

        /** Конструктор по умолчанию. */
        public ReceiptHandler(ReceiptActivity activity){
            super(MainApp.GetCtx().getMainLooper());

            SetActivity(activity);
        }

        /** Привязка к новой активности. */
        public void SetActivity(ReceiptActivity activity) {
            this.activity = activity;
        }

        /** Выполнение команды получения времени. */
        private void DoCmdGetDateTime() {
            TMCommand cmd = new TMCommand();
            cmd.CmdGetDateTime();
            TMLib.getInstance().DoCmd(activity,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
        }

        /** Выполнение команды ОТКРЫТИЕ ЧЕКА. */
        public void DoCmdReceiptOpen(
                String tDate,
                String tTime,
                byte receiptType,
                String tCashier,
                String tCashierINN,
                String tTableNum,
                String tPlaceNum,
                byte copies,
                byte taxMode,
                String tAccount,
                String tComment) {
            TMCommand cmd = new TMCommand();
            if ( ( tDate != null ) && ( tTime != null ) ) cmd.CmdReceiptOpen(tDate,tTime,receiptType,tCashier,tCashierINN,tTableNum,tPlaceNum,copies,taxMode,tAccount,tComment);
            else cmd.CmdReceiptOpen(receiptType,tCashier,tCashierINN,tTableNum,tPlaceNum,copies,taxMode,tAccount,tComment);
            TMLib.getInstance().DoCmd(activity,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT));
        }

        /** Выполнение команды ДОБАВЛЕНИЕ КОДА МАРКИРОВКИ ТОВАРА. */
        public void DoCmdKMTransfer(
                short type,
                byte[] code,
                byte IDproduct,
                byte offsetGS1,
                byte typeCode,
                byte plannedStatus,
                byte processMode,
                byte status) {
            TMCommand cmd = new TMCommand();
            cmd.CmdKMTransfer(type, code, IDproduct, offsetGS1, typeCode, plannedStatus, processMode, status);
            TMLib.getInstance().DoCmd(activity,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT));
        }

        /** Выполнение команды ДОБАВЛЕНИЕ ПОЗИЦИИ ТОВАРА. */
        public void DoCmdReceiptItem(
                String tName,
                String tCode,
                String tPrice,
                String tQty,
                String tUnit,
                byte taxIndex,
                byte calcMethod,
                byte calcObject,
                byte agentType,
                byte depIndex,
                String tDepName,
                String tComment) {
            TMCommand cmd = new TMCommand();
            cmd.CmdReceiptItem(tName,tCode,tPrice,tQty,tUnit,taxIndex,calcMethod,calcObject,agentType,depIndex,tDepName,tComment);
            TMLib.getInstance().DoCmd(activity,cmd,3*CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT));
        }

        /** Выполнение команды ИТОГ ЧЕКА. */
        public void DoCmdReceiptTotal(String tComment) {
            TMCommand cmd = new TMCommand();
            cmd.CmdReceiptTotal(tComment);
            TMLib.getInstance().DoCmd(activity,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT));
        }

        /** Выполнение команды ОПЛАТА. */
        public void DoCmdReceiptTender(
                byte payIndex,
                String tSumma,
                String tAdd,
                String tComment) {
            TMCommand cmd = new TMCommand();
            cmd.CmdReceiptTender(payIndex,tSumma,tAdd,tComment);
            TMLib.getInstance().DoCmd(activity,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT));
        }

        /** Выполнение команды ЗАКРЫТЬ ЧЕК. */
        public void DoCmdReceiptClose() {
            TMCommand cmd = new TMCommand();
            cmd.CmdReceiptClose();
            TMLib.getInstance().DoCmd(activity,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT_REPORT));
        }

        /** Выполнение команды ПОЛУЧИТЬ ЧЕК. */
        public void DoCmdFNGetDoc() {
            TMCommand cmd = new TMCommand();
            cmd.CmdFNGetDoc(0,TMCommand.fn_doc_mode.NO_PRINT);
            TMLib.getInstance().DoCmd(activity,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT));
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получен ответ на команду
            if ( (cmd.GetMainError() != 0) && (TMCommand.commands.CM_ReceiptCancel != cmd.GetCmdCode()) ) {
                //сообщение об ошибке выполнения команды
                MessageBox.Create(MainApp.GetCtx().getString(R.string.header_error), String.format(MainApp.GetCtx().getString(R.string.msg_cmd_error), cmd.GetMainError(), cmd.GetSubError(), cmd.GetCmdCode()) + "\n\n" + TMError.GetText((byte) cmd.GetMainError()), MessageBox.option.OK | MessageBox.option.WARN).show(activity.getSupportFragmentManager(), MessageBox.TAG);
            }
            else {
                //обработка успешных ответов
                switch ((byte) cmd.GetCmdCode()) {

                    case TMCommand.commands.CM_GetDateTime: {
                        //время получено, выполнение команды ОТКРЫТИЕ ЧЕКА
                        if ( cheque != null ) {
                            cheque.open(cmd.GetFieldValue(5),cmd.GetFieldValue(6));
                        }
                        break;
                    }

                    case TMCommand.commands.CM_ReceiptCancel: {
                        if ( cheque != null ) {
                            //успешно выполнена
                            activity.isExit = true;
                            MessageBox.Create(MainApp.GetCtx().getString(R.string.header_success), MainApp.GetCtx().getString(R.string.msg_cmd_success) + "\n\nЧЕК ОТМЕНЕН", MessageBox.option.OK).show(activity.getSupportFragmentManager(), MessageBox.TAG);
                        }
                        break;
                    }

                    case TMCommand.commands.CM_ReceiptClose: {
                        //чек успешно закрыт
                        activity.isExit = true;
                        //если нужен обмен с ОФД
                        if ( !IsAutonom() ) TMLib.getInstance().StartOFD();
                        //если нужен обмен с ОИСМ
                        if ( IsTMT() && !IsAutonom() && isKM ) TMLib.getInstance().StartOISM();
                        //проверяем что вернули QR код
                        String qr = cmd.GetFieldValue(6);
                        if ( qr.length() > 8 ) {
                            sQR = qr;
                            DoCmdFNGetDoc();
                        } else {
                            MessageBox.Create(MainApp.GetCtx().getString(R.string.header_success), MainApp.GetCtx().getString(R.string.msg_cmd_success) + "\n\nЗАБЕРИТЕ ЧЕК", MessageBox.option.OK).show(activity.getSupportFragmentManager(), MessageBox.TAG);
                        }
                        break;
                    }

                    case TMCommand.commands.CM_FNGetDoc: {
                        //получаем ФД,ФП
                        activity.dialogViewReceipt(sQR,cmd.GetFieldHexDW(8),cmd.GetFieldHexDW(9));
                        break;
                    }

                    case TMCommand.commands.CM_ReceiptOpen: {
                        //начинаем добавлять товар
                        currentGood = 0;
                        //для товара пробуем сохранить маркировку
                        if ( !goodList.get(currentGood).transferKM() ) {
                            //добавляем товар
                            goodList.get(currentGood++).add();
                        }
                        break;
                    }

                    case TMCommand.commands.CM_KMTransfer: {
                        //добавляем товар
                        goodList.get(currentGood++).add();
                        break;
                    }

                    case TMCommand.commands.CM_ReceiptItem: {
                        //выводим сумму
                        sReceiptTotal = cmd.GetFieldValue(6);
                        try {
                            View v = activity.getSupportFragmentManager().findFragmentByTag(TAG_ADD).requireView();
                            ((TextView) v.findViewById(R.id.receipt_sum)).setText(sReceiptTotal);
                        }
                        catch (Exception ignored){}

                        if ( currentGood < goodList.size() ) {
                            //продолжаем добавлять товар

                            //для товара пробуем сохранить маркировку
                            if ( !goodList.get(currentGood).transferKM() ) {
                                //добавляем товар
                                goodList.get(currentGood++).add();
                            }
                        }
                        else {
                            //выполняем команду ИТОГ
                            activity.viewTotalDialog();
                        }
                        break;
                    }

                    case TMCommand.commands.CM_ReceiptTotal: {
                        sReceiptTotal = cmd.GetFieldValue(5);
                        sReceiptRemaind = sReceiptTotal;
                        //переходим к оплате
                        FragmentTransaction fragmentTransaction = activity.getSupportFragmentManager().beginTransaction();
                        fragmentTransaction.replace(R.id.receipt, activity.fragmentPay, TAG_PAY);
                        fragmentTransaction.commit();
                        break;
                    }

                    case TMCommand.commands.CM_ReceiptTender: {
                        sReceiptRemaind = cmd.GetFieldValue(5);
                        //String charge = cmd.GetFieldValue(6);

                        try {
                            View v = activity.getSupportFragmentManager().findFragmentByTag(TAG_PAY).requireView();
                            ((TextView) v.findViewById(R.id.pay_sum)).setText(sReceiptRemaind);
                            ((TextView) v.findViewById(R.id.receipt_remaind)).setText(sReceiptRemaind);
                        }
                        catch (Exception ignored){}
                        break;
                    }
                }
            }
        }

        @Override
        public void onTimeOut() {
            //при отмене  выходим из чека
            try {
                if (TMLib.getInstance().getLastCmd().GetCmdCode() == TMCommand.commands.CM_ReceiptCancel)
                    activity.isExit = true;
            }
            catch (Exception ignored) {}

            //сообщение о превышении таймаута обращения к контроллеру ФН
            MessageBox.Create(MainApp.GetCtx().getString(R.string.header_error), MainApp.GetCtx().getString(R.string.msg_timeout), MessageBox.option.OK|MessageBox.option.WARN).show(activity.getSupportFragmentManager(), MessageBox.TAG);
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            MessageBox.Create(MainApp.GetCtx().getString(R.string.header_error), MainApp.GetCtx().getString(R.string.msg_service_fail)+"\n\n"+errText, MessageBox.option.OK|MessageBox.option.WARN).show(activity.getSupportFragmentManager(), MessageBox.TAG);
        }
    }
}
