package ru.nilsoft.example;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import java.util.ArrayList;

import ru.nilsoft.tm.TMLib;

/**
 * Установка разрешений для работы приложения и сервиса.
 * Получение информации о POS терминале.
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class PermissionsActivity extends AppCompatActivity {
    /** Сборка списка разрешений приложения. */
    private static String [] getPermissions() {
        ArrayList<String> permissions = new ArrayList<>();

        //обычные пермишены
        permissions.add(Manifest.permission.INTERNET);
        permissions.add(Manifest.permission.CAMERA);

        if ( Build.VERSION.SDK_INT >= Build.VERSION_CODES.P ) permissions.add(Manifest.permission.FOREGROUND_SERVICE);

        String [] s = new String[permissions.size()];
        return permissions.toArray(s);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_permissions);
    }

    @Override
    protected void onStart() {
        super.onStart();

        RequestPermissions();
    }

    /** Обработка нажатия кнопки ПОВТОР. */
    public void onButtonOK(View view) {
        RequestPermissions();
    }

    /** Запрос прав от пользователя (доступно только в Android 6.0 и выше). */
    public void RequestPermissions() {
        ClearText();
        //просим разрешение (начиная с Android 6.0)
        if ( Build.VERSION.SDK_INT >= Build.VERSION_CODES.M ) {
            requestPermissions(getPermissions(), 0);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        AddText("Android " + Build.ID + ":\n");
        if ((requestCode == 0) && (grantResults.length > 0)) {
            for (int i = 0; i < grantResults.length; i++) {
                if (grantResults[i] != PackageManager.PERMISSION_GRANTED) {
                    AddText("  fail: " + permissions[i] + "\n");
                    return;
                }
                Log.d(this.getLocalClassName(), "granted: " + permissions[i]);
                AddText("  granted: " + permissions[i] + "\n");
            }

            //пермишенов достаточно

            //запускаем работу
            init(this.getApplicationContext());

            //завершаем активность
            finish();
        }
    }

    /** Вывод текста. */
    public void AddText(String text) {
        TextView viewText = findViewById(R.id.viewPermissions);
        if ( viewText != null ) viewText.append(text);
    }

    /** Сброс текста. */
    public void ClearText() {
        TextView viewText = findViewById(R.id.viewPermissions);
        if ( viewText != null ) viewText.setText("");
    }

    /**
     * Проверка наличия разрешений для работы.
     * @param ctx контекст
     * @return true: разрешения есть, false: необходимо запросить разрешения.
     */
    public static boolean check(Context ctx) {
        //запрос разрешений
        if ( Build.VERSION.SDK_INT >= Build.VERSION_CODES.M ) {
            for( String permission: getPermissions()) {
                if ( ctx.checkSelfPermission(permission) != PackageManager.PERMISSION_GRANTED ) {
                    Log.d(PermissionsActivity.class.getSimpleName(),"not granted: "+permission);
                    return false;
                }
            }
        }

        //инициализация SDK POS если пермишенов хватает
        //если нехватает то инициализация пройдет после получения пермишенов
        init(ctx);

        return true;
    }

    /**
     * Иницализация работы с ККТ
     * @param ctx контекст приложения.
     */
    public static void init(final Context ctx) {
        //инициализация работы с KKT
        Log.d("PermissionsActivity","init TMService: "+TMLib.getInstance().init(ctx));
    }
}
