package ru.nilsoft.example;

import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMError;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMLibHandler;

/**
 * Получение текущих счетчиков сумм из контроллера ФН.
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class MoneyActivity extends AppCompatActivity {
    /** Handler для работы c контроллером ФН. */
    private Handler h;
    /** Уже выполнено. */
    private boolean isDone = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_money);

        //создание хендлера
        h = new LibHandler();
    }

    @Override
    protected void onStart() {
        super.onStart();

        //регистрация хендлера для получения ответов от контроллера ФН
        TMLib.getInstance().registerHandler(h);

        if ( !isDone ) {
            isDone = true;
            //начинаем процедуру получения счетчиков сумм:
            //сперва получаем время из контроллера (рекомендуется использовать время ККТ, так как Android время может измениться при пересечении поясов или синхронизации по сети).
            FRGetDateTime();
        }
    }

    @Override
    protected void onStop() {
        //освобождение хендлера
        TMLib.getInstance().unregisterHandler(h);

        super.onStop();
    }

    /** Обработка нажатия кнопки ОК. */
    public void onButtonOK(View view) {
        finish();
    }

    /** Выполнение команды получения расширенного электронного отчета. */
    public void FRGetReportExt() {
        TMCommand cmd = new TMCommand();
        cmd.CmdGetReportExt();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /**
     * Выполнение команды получения отчета.
     * @param tDate текущая дата.
     * @param tTime текущее время.
     */
    private void FRGetMoney(String tDate, String tTime) {
        TMCommand cmd = new TMCommand();
        if ( ( tDate != null ) && ( tTime != null ) ) cmd.CmdGetMoney(tDate, tTime);
        else cmd.CmdGetMoney();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Выполнение команды получения времени. */
    public void FRGetDateTime() {
        TMCommand cmd = new TMCommand();
        cmd.CmdGetDateTime();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Хендлер для обработки сообщений от контролера ФН. */
    private class LibHandler extends TMLibHandler {

        /** Конструктор по умолчанию. */
        public LibHandler(){
            super(MainApp.GetCtx().getMainLooper());
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получен ответ на команду
            switch((byte) cmd.GetCmdCode())
            {
                case TMCommand.commands.CM_GetDateTime: {
                    if (cmd.GetMainError() == 0) {
                        //время от контроллера ФН успешно получено
                        FRGetMoney(cmd.GetFieldValue(5), cmd.GetFieldValue(6));
                    }
                    else FRGetMoney(null,null); //если не получено время от контроллера ФН
                }
                break;

                case TMCommand.commands.CM_GetMoney: {
                    TextView viewText = findViewById(R.id.viewMoney);
                    if ( cmd.GetMainError() != 0 ) {
                        //ошибка получения счетчиков сумм от ККТ
                        viewText.append(String.format(getString(R.string.msg_cmd_error), cmd.GetMainError(), cmd.GetSubError(), cmd.GetCmdCode()) + "\n"+TMError.GetText((byte)cmd.GetMainError())+"\n");
                    }
                    else{
                        //вывод счетчиков сумм
                        String text =
                                getString(R.string.report_purchase_cash)+" "+cmd.GetFieldValue(5)+"\n"+
                                getString(R.string.report_rev_purchase_cash)+" "+cmd.GetFieldValue(6)+"\n"+
                                getString(R.string.report_refund_cash)+" "+cmd.GetFieldValue(7)+"\n"+
                                getString(R.string.report_rev_refund_cash)+" "+cmd.GetFieldValue(8)+"\n\n"+
                                getString(R.string.report_purchase_card)+" "+cmd.GetFieldValue(9)+"\n"+
                                getString(R.string.report_rev_purchase_card)+" "+cmd.GetFieldValue(10)+"\n"+
                                getString(R.string.report_refund_card)+" "+cmd.GetFieldValue(11)+"\n"+
                                getString(R.string.report_rev_refund_card)+" "+cmd.GetFieldValue(12)+"\n\n"+
                                getString(R.string.report_purchase_advance)+" "+cmd.GetFieldValue(13)+"\n"+
                                getString(R.string.report_rev_purchase_advance)+" "+cmd.GetFieldValue(14)+"\n"+
                                getString(R.string.report_refund_advance)+" "+cmd.GetFieldValue(15)+"\n"+
                                getString(R.string.report_rev_refund_advance)+" "+cmd.GetFieldValue(16)+"\n\n"+
                                getString(R.string.report_purchase_credit)+" "+cmd.GetFieldValue(17)+"\n"+
                                getString(R.string.report_rev_purchase_credit)+" "+cmd.GetFieldValue(18)+"\n"+
                                getString(R.string.report_refund_credit)+" "+cmd.GetFieldValue(19)+"\n"+
                                getString(R.string.report_rev_refund_credit)+" "+cmd.GetFieldValue(20)+"\n\n"+
                                getString(R.string.report_purchase_other)+" "+cmd.GetFieldValue(21)+"\n"+
                                getString(R.string.report_rev_purchase_other)+" "+cmd.GetFieldValue(22)+"\n"+
                                getString(R.string.report_refund_other)+" "+cmd.GetFieldValue(23)+"\n"+
                                getString(R.string.report_rev_refund_other)+" "+cmd.GetFieldValue(24)+"\n\n"+
                                getString(R.string.report_purchase_total)+" "+cmd.GetFieldValue(25)+"\n"+
                                getString(R.string.report_rev_purchase_total)+" "+cmd.GetFieldValue(26)+"\n"+
                                getString(R.string.report_refund_total)+" "+cmd.GetFieldValue(27)+"\n"+
                                getString(R.string.report_rev_refund_total)+" "+cmd.GetFieldValue(28)+"\n\n";
//                                getString(R.string.report_cashbox_in)+" "+cmd.GetFieldValue(29)+"\n"+
//                                getString(R.string.report_cashbox_out)+" "+cmd.GetFieldValue(30)+"\n"+
//                                getString(R.string.report_cashbox_sum)+" "+cmd.GetFieldValue(31)+"\n\n";
                        viewText.setText(text);

                        //делаем расширенный отчет
                        FRGetReportExt();
                    }
                }
                break;

                case TMCommand.commands.CM_ReportExt: {
                    TextView viewText = findViewById(R.id.viewMoney);
                    if ( cmd.GetMainError() != 0 ) {
                        //ошибка получения счетчиков сумм от ККТ
                        viewText.append(String.format(getString(R.string.msg_cmd_error), cmd.GetMainError(), cmd.GetSubError(), cmd.GetCmdCode()) + "\n"+TMError.GetText((byte)cmd.GetMainError())+"\n");
                    }
                    else{
                        //вывод счетчиков сумм
                        String text =
//                                getString(R.string.report_purchase_total)+" "+cmd.GetFieldValue(5)+"\n"+
//                                getString(R.string.report_rev_purchase_total)+" "+cmd.GetFieldValue(6)+"\n"+
//                                getString(R.string.report_refund_total)+" "+cmd.GetFieldValue(7)+"\n"+
//                                getString(R.string.report_rev_refund_total)+" "+cmd.GetFieldValue(8)+"\n"+
                                getString(R.string.report_corr_purchase_total)+" "+cmd.GetFieldValue(9)+"\n"+
                                getString(R.string.report_corr_refund_total)+" "+cmd.GetFieldValue(10)+"\n\n"+
                                getString(R.string.report_cashbox_in)+" "+cmd.GetFieldValue(11)+"\n"+
                                getString(R.string.report_cashbox_out)+" "+cmd.GetFieldValue(12)+"\n"+
                                getString(R.string.report_cashbox_sum)+" "+cmd.GetFieldValue(13)+"\n\n"+
                                getString(R.string.report_purchase_full)+" "+cmd.GetFieldValue(14)+"\n"+
                                getString(R.string.report_rev_purchase_full)+" "+cmd.GetFieldValue(15)+"\n"+
                                getString(R.string.report_refund_full)+" "+cmd.GetFieldValue(16)+"\n"+
                                getString(R.string.report_rev_refund_full)+" "+cmd.GetFieldValue(17)+"\n"+
                                getString(R.string.report_corr_purchase_full)+" "+cmd.GetFieldValue(18)+"\n"+
                                getString(R.string.report_corr_refund_full)+" "+cmd.GetFieldValue(19);
                        viewText.append(text);
                    }
                }
                break;
            }
        }

        @Override
        public void onTimeOut() {
            //сообщение о превышении таймаута обращения к контроллеру ФН
            TextView viewText = findViewById(R.id.viewMoney);
            viewText.setText(getString(R.string.msg_timeout));
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            TextView viewText = findViewById(R.id.viewMoney);
            viewText.setText(getString(R.string.msg_service_fail)+"\n"+errText);
        }
    }
}
