package ru.nilsoft.example;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMLib;

/**
 * Класс MainApp используется для привязки SingleTone объектов.
 */
public class MainApp extends Application {
    /** Таймаут по умолчанию обращения к ТМ. */
    public static final int DEFAULT_TM_TIMEOUT = 5000;
    /** Имя файла настроек. */
    public static final String SETTINGS = "settings";
    /** Для доступа к настройкам. */
    public static SharedPreferences settings;
    /** Идентификатор уведомления. */
    private static Context selfCtx;

    /**
     * Выполняется при запуске приложения.
     */
    @Override
    public final void onCreate() {
        super.onCreate();
        selfCtx = this;

        //инициализация интерфейсной библиотеки (SingleTone) для работы с контроллером ФН
        Log.d("example","MainApp init TMService: "+TMLib.getInstance().init(this));

        //доступ к настройкам
        settings = getSharedPreferences(MainApp.SETTINGS, Context.MODE_PRIVATE);
    }

    /**
     * Получение контекста приложения.
     */
    public static Context GetCtx() {return selfCtx;}

    /**
     * Вывод сообщения в приложении.
     * @param text текст сообщения
     */
    public static void MakeNotification(final String text) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(() -> Toast.makeText(selfCtx, text, Toast.LENGTH_LONG).show());
    }

    /**
     * Получение названия системы налогообложения по коду.
     * @param code идентификатор налога.
     * @return строка названия.
     */
    public static String GetTaxSystemName(int code){
        switch(code){
            case TMCommand.tax_types.DEFAULT: return selfCtx.getString(R.string.tax_type_default);
            case TMCommand.tax_types.COMMON: return selfCtx.getString(R.string.tax_type_common);
            case TMCommand.tax_types.INCOME: return selfCtx.getString(R.string.tax_type_income);
            case TMCommand.tax_types.SIMPLE: return selfCtx.getString(R.string.tax_type_simple);
            case TMCommand.tax_types.INCOME_TYPES: return selfCtx.getString(R.string.tax_type_income_types);
            case TMCommand.tax_types.SINGLE_FARMER: return selfCtx.getString(R.string.tax_type_single_farmer);
            case TMCommand.tax_types.PATENT: return selfCtx.getString(R.string.tax_type_patent);
            default: return "";
        }
    }

    /**
     * Получение кода системы налогообложения по названию.
     * @param name название.
     * @return код.
     */
    public static byte GetTaxSystemCode(final String name){
        if ( name.equals(selfCtx.getString(R.string.tax_type_default)) ) return TMCommand.tax_types.DEFAULT;
        else if ( name.equals(selfCtx.getString(R.string.tax_type_common)) ) return TMCommand.tax_types.COMMON;
        else if ( name.equals( selfCtx.getString(R.string.tax_type_income)) ) return TMCommand.tax_types.INCOME;
        else if ( name.equals( selfCtx.getString(R.string.tax_type_simple)) ) return TMCommand.tax_types.SIMPLE;
        else if ( name.equals( selfCtx.getString(R.string.tax_type_income_types)) ) return TMCommand.tax_types.INCOME_TYPES;
        else if ( name.equals( selfCtx.getString(R.string.tax_type_single_farmer)) ) return TMCommand.tax_types.SINGLE_FARMER;
        else if ( name.equals( selfCtx.getString(R.string.tax_type_patent)) ) return TMCommand.tax_types.PATENT;
        return 0;
    }

}
