package ru.nilsoft.example;

import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMError;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMLibHandler;

/**
 * Установка печатного заголовка и завершающей части документов.
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class HeaderActivity extends AppCompatActivity implements MessageBox.CallBack {
    /** Handler для работы c контроллером ФН. */
    private Handler h;
    /** Выход из диалога. */
    boolean isExit = false;
    /** Полный или сокращенный заголовок. */
    boolean isFullHeader = false;

    /** Названия настроек для сохранения в файл настроек приложения */
    public static final class sets{
        /** Заголовок чека. */
        static final String HEADER = "Header";
        /** Заголовока чека (полный). */
        static final String HEADER_EXT = "HeaderExt";
        /** Окончание чека. */
        static final String TAIL = "Tail";
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_header);

        //создание хендлера
        h = new LibHandler();
    }

    @Override
    protected void onStart() {
        super.onStart();

        //регистрация хендлера для получения ответов от контроллера ФН
        TMLib.getInstance().registerHandler(h);

        //заполнение данными (считываются из файла настроек приложения)
        ((TextView)findViewById(R.id.editHeader)).setText(MainApp.settings.getString(sets.HEADER,""));
        ((TextView)findViewById(R.id.editHeaderExt)).setText(MainApp.settings.getString(sets.HEADER_EXT,""));
        ((TextView)findViewById(R.id.editTail)).setText(MainApp.settings.getString(sets.TAIL,""));
    }

    @Override
    protected void onStop() {
        //освобождение хендлера
        TMLib.getInstance().unregisterHandler(h);

        //сохранение данных (сохранение в файл настроек приложения)
        SharedPreferences.Editor editor = MainApp.settings.edit();
        editor.putString(sets.HEADER,String.valueOf(((TextView)findViewById(R.id.editHeader)).getText()));
        editor.putString(sets.HEADER_EXT,String.valueOf(((TextView)findViewById(R.id.editHeaderExt)).getText()));
        editor.putString(sets.TAIL,String.valueOf(((TextView)findViewById(R.id.editTail)).getText()));
        editor.apply();

        super.onStop();
    }

    /** Обработка нажатия кнопки ОТМЕНА. */
    public void onButtonCancel(View view) {
        finish(); //завершение диалога
    }

    /** При позитивном завершении диалога (нажатие кнопки ОК). */
    public void onMessageBoxPositiveClick(DialogInterface dialog) {
        //завершаем активность
        if ( isExit ) finish();
    }

    /** При негативном завершении диалога (нажатие кнопки ОТМЕНА). */
    public void onMessageBoxNegativeClick(DialogInterface dialog) {
    }

    /** Обработка нажатия кнопки СЧИТАТЬ (окончания чека). */
    public void onButtonGetTail(View view) {
        //выполнение команды получения окончания чека
        TMCommand cmd = new TMCommand();
        cmd.CmdGetTail();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Обработка нажатия кнопки СЧИТАТЬ (заголовок чека). */
    public void onButtonGetHeader(View view) {
        //выполнение команды получения заголовка чека
        isFullHeader = false;
        TMCommand cmd = new TMCommand();
        cmd.CmdGetHeader();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Обработка нажатия кнопки СЧИТАТЬ (расширенный заголовок чека). */
    public void onButtonGetHeaderExt(View view) {
        //выполнение команды получения расширенного заголовка чека
        isFullHeader = true;
        TMCommand cmd = new TMCommand();
        cmd.CmdGetHeader();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Обработка нажатия кнопки УСТАНОВИТЬ (окончание чека). */
    public void onButtonSetTail(View view) {
        String [] tStrings = String.valueOf(((TextView)findViewById(R.id.editTail)).getText()).split("\n");
        TMCommand cmd = new TMCommand();
        cmd.CmdSetTail(tStrings);
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Обработка нажатия кнопки УСТАНОВИТЬ (заголовок чека). */
    public void onButtonSetHeader(View view) {
        isFullHeader = false;
        String [] tStrings = String.valueOf(((TextView)findViewById(R.id.editHeader)).getText()).split("\n");
        TMCommand cmd = new TMCommand();
        cmd.CmdSetHeader(tStrings);
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /** Обработка нажатия кнопки УСТАНОВИТЬ (расширенный заголовок чека). */
    public void onButtonSetHeaderExt(View view) {
        isFullHeader = true;
        String [] tStrings = String.valueOf(((TextView)findViewById(R.id.editHeaderExt)).getText()).split("\n");
        TMCommand cmd = new TMCommand();
        cmd.CmdSetHeaderExt(tStrings);
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /* Хендлер для обработки сообщений от контролера ФН. */
    class LibHandler extends TMLibHandler {

        /** Конструктор по умолчанию. */
        public LibHandler(){
            super(MainApp.GetCtx().getMainLooper());
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получен ответ на команду
            if ( cmd.GetMainError() == 0 ) {
                //обработка успешных ответов
                switch((byte) cmd.GetCmdCode()) {
                    case TMCommand.commands.CM_GetHeader: {
                        if ( isFullHeader ) {
                            //полный заголовок
                            String tString = cmd.GetFieldString(5) + "\n" +
                                    cmd.GetFieldString(6) + "\n" +
                                    cmd.GetFieldString(7) + "\n" +
                                    cmd.GetFieldString(8) + "\n" +
                                    cmd.GetFieldString(9) + "\n" +
                                    cmd.GetFieldString(10);
                            ((TextView) findViewById(R.id.editHeaderExt)).setText(tString);
                        }
                        else {
                            //сокращенный заголовок
                            String tString = cmd.GetFieldString(6).substring(1,39) + "\n" +
                                    cmd.GetFieldString(7).substring(1,39) + "\n" +
                                    cmd.GetFieldString(8).substring(1,39) + "\n" +
                                    cmd.GetFieldString(9).substring(1,39);
                            ((TextView) findViewById(R.id.editHeader)).setText(tString);
                        }
                        break;
                    }

                    case TMCommand.commands.CM_GetTail: {
                        String tString = cmd.GetFieldString(5)+"\n" +
                                cmd.GetFieldString(6)+"\n" +
                                cmd.GetFieldString(7)+"\n" +
                                cmd.GetFieldString(8);
                        Log.d(this.getClass().getSimpleName(),tString);
                        ((TextView)findViewById(R.id.editTail)).setText(tString);
                        break;
                    }

                    case TMCommand.commands.CM_SetHeader:
                    case TMCommand.commands.CM_SetHeaderExt:
                    case TMCommand.commands.CM_SetTail:
                        MessageBox.Create(getString(R.string.header_success), getString(R.string.msg_cmd_success), MessageBox.option.OK).show(getSupportFragmentManager(), MessageBox.TAG);
                        break;
                }
            }
            else {
                //сообщение об ошибке выполнения команды
                MessageBox.Create(getString(R.string.header_error), String.format(getString(R.string.msg_cmd_error),cmd.GetMainError(),cmd.GetSubError(),cmd.GetCmdCode())+ "\n\n" + TMError.GetText((byte)cmd.GetMainError()), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
            }
        }

        @Override
        public void onTimeOut() {
            //сообщение о превышении таймаута обращения к контроллеру ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_timeout), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_service_fail)+"\n\n"+errText, MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }
    }
}
