package ru.nilsoft.example;

import android.content.DialogInterface;
import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMError;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMLibHandler;

/**
 * Настройка параметров печатных документов и логики работы контроллера ФН.
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class DocumentsParamsActivity extends AppCompatActivity implements MessageBox.CallBack {
    /** Handler для работы c контроллером ФН. */
    private Handler h;
    /** Выход из активности. */
    private boolean isExit = false;

    /** Параметры документов (часть 1). */
    private short param1 = 0;
    /** Параметры документов (часть 2). */
    private short param2 = 0;
    /** Параметры документов (часть 3). */
    private short linefeed = 0;
    /** Параметры документов (часть 4). */
    private short param4 = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_documents_params);

        //создание хендлера
        h = new LibHandler();
    }

    @Override
    protected void onStart() {
        super.onStart();

        //регистрация хендлера для получения ответов от контроллера ФН
        TMLib.getInstance().registerHandler(h);

        //получение параметров из контроллера ФН
        FRGetParam();
    }

    @Override
    protected void onStop() {
        //освобождение хендлера
        TMLib.getInstance().unregisterHandler(h);

        super.onStop();
    }

    /** При позитивном завершении диалога (нажатие кнопки ОК). */
    public void onMessageBoxPositiveClick(DialogInterface dialog) {
        //завершаем активность
        if ( isExit ) finish();
    }

    /** При негативном завершении диалога (нажатие кнопки ОТМЕНА). */
    public void onMessageBoxNegativeClick(DialogInterface dialog) {
    }

    /** Обработка нажатия кнопки OK. */
    public void onButtonOK(View view) {
        //получение настроек параметра 1
        if ( ((CheckBox)findViewById(R.id.par1_0001h)).isChecked() ) param1|=TMCommand.doc_params1.NOT_PRINT_TAIL; else param1&=~TMCommand.doc_params1.NOT_PRINT_TAIL;
        if ( ((CheckBox)findViewById(R.id.par1_0002h)).isChecked() ) param1|=TMCommand.doc_params1.NOT_SET_EMPTY_LINE; else param1&=~TMCommand.doc_params1.NOT_SET_EMPTY_LINE;
        if ( ((CheckBox)findViewById(R.id.par1_0004h)).isChecked() ) param1|=TMCommand.doc_params1.NOT_PRINT_ZERO_COUNT; else param1&=~TMCommand.doc_params1.NOT_PRINT_ZERO_COUNT;
        if ( ((CheckBox)findViewById(R.id.par1_0008h)).isChecked() ) param1|=TMCommand.doc_params1.RESERVED_0008; else param1&=~TMCommand.doc_params1.RESERVED_0008;
        if ( ((CheckBox)findViewById(R.id.par1_0010h)).isChecked() ) param1|=TMCommand.doc_params1.PRINT_HEAD_BEFORE; else param1&=~TMCommand.doc_params1.PRINT_HEAD_BEFORE;
        if ( ((CheckBox)findViewById(R.id.par1_0020h)).isChecked() ) param1|=TMCommand.doc_params1.NOT_PRINT_RESOURCES; else param1&=~TMCommand.doc_params1.NOT_PRINT_RESOURCES;
        if ( ((CheckBox)findViewById(R.id.par1_0040h)).isChecked() ) param1|=TMCommand.doc_params1.NOT_PRINT_QTY_FOR_SINGLES; else param1&=~TMCommand.doc_params1.NOT_PRINT_QTY_FOR_SINGLES;
        if ( ((CheckBox)findViewById(R.id.par1_0080h)).isChecked() ) param1|=TMCommand.doc_params1.NOT_REQUIRE_START_CMD; else param1&=~TMCommand.doc_params1.NOT_REQUIRE_START_CMD;
        if ( ((CheckBox)findViewById(R.id.par1_0100h)).isChecked() ) param1|=TMCommand.doc_params1.RESERVED_0100; else param1&=~TMCommand.doc_params1.RESERVED_0100;
        if ( ((CheckBox)findViewById(R.id.par1_0200h)).isChecked() ) param1|=TMCommand.doc_params1.RESERVED_0200; else param1&=~TMCommand.doc_params1.RESERVED_0200;
        if ( ((CheckBox)findViewById(R.id.par1_0400h)).isChecked() ) param1|=TMCommand.doc_params1.RESERVED_0400; else param1&=~TMCommand.doc_params1.RESERVED_0400;
        if ( ((CheckBox)findViewById(R.id.par1_0800h)).isChecked() ) param1|=TMCommand.doc_params1.RESERVED_0800; else param1&=~TMCommand.doc_params1.RESERVED_0800;
        if ( ((CheckBox)findViewById(R.id.par1_1000h)).isChecked() ) param1|=TMCommand.doc_params1.RESERVED_1000; else param1&=~TMCommand.doc_params1.RESERVED_1000;
        if ( ((CheckBox)findViewById(R.id.par1_2000h)).isChecked() ) param1|=TMCommand.doc_params1.PRINT_CLOSE_SHIFT; else param1&=~TMCommand.doc_params1.PRINT_CLOSE_SHIFT;
        if ( ((CheckBox)findViewById(R.id.par1_4000h)).isChecked() ) param1|=TMCommand.doc_params1.RESERVED_4000; else param1&=~TMCommand.doc_params1.RESERVED_4000;
        if ( ((CheckBox)findViewById(R.id.par1_8000h)).isChecked() ) param1|=TMCommand.doc_params1.PRINT_TAXES; else param1&=~TMCommand.doc_params1.PRINT_TAXES;

        //получение настроек параметра 2
        if ( ((CheckBox)findViewById(R.id.par2_0001h)).isChecked() ) param2|=TMCommand.doc_params2.AUTO_ENCASHMENT; else param2&=~TMCommand.doc_params2.AUTO_ENCASHMENT;
        if ( ((CheckBox)findViewById(R.id.par2_0002h)).isChecked() ) param2|=TMCommand.doc_params2.PRINT_GRAPH_HEADER; else param2&=~TMCommand.doc_params2.PRINT_GRAPH_HEADER;
        if ( ((CheckBox)findViewById(R.id.par2_0004h)).isChecked() ) param2|=TMCommand.doc_params2.RESERVED_0004; else param2&=~TMCommand.doc_params2.RESERVED_0004;
        if ( ((CheckBox)findViewById(R.id.par2_0008h)).isChecked() ) param2|=TMCommand.doc_params2.RESERVED_0008; else param2&=~TMCommand.doc_params2.RESERVED_0008;
        if ( ((CheckBox)findViewById(R.id.par2_0010h)).isChecked() ) param2|=TMCommand.doc_params2.NOT_PRINT_RUB; else param2&=~TMCommand.doc_params2.NOT_PRINT_RUB;
        if ( ((CheckBox)findViewById(R.id.par2_0020h)).isChecked() ) param2|=TMCommand.doc_params2.NOT_CUT_TAPE; else param2&=~TMCommand.doc_params2.NOT_CUT_TAPE;
        if ( ((CheckBox)findViewById(R.id.par2_0040h)).isChecked() ) param2|=TMCommand.doc_params2.PRINT_DISCOUNTS; else param2&=~TMCommand.doc_params2.PRINT_DISCOUNTS;
        if ( ((CheckBox)findViewById(R.id.par2_0080h)).isChecked() ) param2|=TMCommand.doc_params2.PRINT_UNIDOC_HEADER; else param2&=~TMCommand.doc_params2.PRINT_UNIDOC_HEADER;
        if ( ((CheckBox)findViewById(R.id.par2_0100h)).isChecked() ) param2|=TMCommand.doc_params2.PRINT_DEPARTMENTS; else param2&=~TMCommand.doc_params2.PRINT_DEPARTMENTS;
        if ( ((CheckBox)findViewById(R.id.par2_0200h)).isChecked() ) param2|=TMCommand.doc_params2.NARROW_CHEQUE; else param2&=~TMCommand.doc_params2.NARROW_CHEQUE;
        if ( ((CheckBox)findViewById(R.id.par2_0400h)).isChecked() ) param2|=TMCommand.doc_params2.RESERVED_0400; else param2&=~TMCommand.doc_params2.RESERVED_0400;
        if ( ((CheckBox)findViewById(R.id.par2_0800h)).isChecked() ) param2|=TMCommand.doc_params2.PRINT_OPEN_SHIFT; else param2&=~TMCommand.doc_params2.PRINT_OPEN_SHIFT;
        if ( ((CheckBox)findViewById(R.id.par2_1000h)).isChecked() ) param2|=TMCommand.doc_params2.CRLF_DELIMIT_PARAM; else param2&=~TMCommand.doc_params2.CRLF_DELIMIT_PARAM;
        if ( ((CheckBox)findViewById(R.id.par2_2000h)).isChecked() ) param2|=TMCommand.doc_params2.PRINT_DEP_QUANTITY; else param2&=~TMCommand.doc_params2.PRINT_DEP_QUANTITY;
        if ( ((CheckBox)findViewById(R.id.par2_4000h)).isChecked() ) param2|=TMCommand.doc_params2.WAIT_START_SYM; else param2&=~TMCommand.doc_params2.WAIT_START_SYM;
        if ( ((CheckBox)findViewById(R.id.par2_8000h)).isChecked() ) param2|=TMCommand.doc_params2.RESERVED_8000; else param2&=~TMCommand.doc_params2.RESERVED_8000;

        //получение настроек параметра 4 (дополнительные параметры)
        if ( ((CheckBox)findViewById(R.id.par4_0001h)).isChecked() ) param4|=TMCommand.doc_params4.RESERVED_0001; else param2&=~TMCommand.doc_params4.RESERVED_0001;
        if ( ((CheckBox)findViewById(R.id.par4_0002h)).isChecked() ) param4|=TMCommand.doc_params4.DYNAMIC_POSITION_QR; else param2&=~TMCommand.doc_params4.DYNAMIC_POSITION_QR;
        if ( ((CheckBox)findViewById(R.id.par4_0004h)).isChecked() ) param4|=TMCommand.doc_params4.NOT_PRINT_READY_DOC; else param2&=~TMCommand.doc_params4.NOT_PRINT_READY_DOC;
        if ( ((CheckBox)findViewById(R.id.par4_0008h)).isChecked() ) param4|=TMCommand.doc_params4.COMBINE_IDENTICAL_ITEMS; else param2&=~TMCommand.doc_params4.COMBINE_IDENTICAL_ITEMS;

        //установка параметров в контроллер ФН
        FRSetParam(param1,param2,linefeed,param4);
    }

    /** Обработка нажатия кнопки ОТМЕНА. */
    public void onButtonCancel(View view) {
        finish(); //завершение активности
    }

    /**
     * Получение параметров.
     */
    private void FRGetParam() {
        TMCommand cmd = new TMCommand();
        cmd.CmdGetParams();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /**
     * Установка параметров.
     * @param p1 параметр 1.
     * @param p2 параметр 2.
     * @param lf промежуток между строк для печати.
     * @param p4 параметр 4 (дополнительный параметр).
     */
    private void FRSetParam(int p1, int p2, int lf, int p4) {
        TMCommand cmd = new TMCommand();
        cmd.CmdSetParams((short)p1,(short)p2,(short)lf,(short)p4);
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /**
     * Заполнение диалога данными, полученными от контроллера ФН.
     * @param p1 параметр 1.
     * @param p2 параметр 2.
     * @param lf промежуток между строк для печати.
     * @param p4 параметр 4 (дополнительный параметр).
     */
    private void SetViewParse(int p1, int p2, int lf, int p4) {
        //распарсивание параметра 1
        ((CheckBox)findViewById(R.id.par1_0001h)).setChecked((p1&TMCommand.doc_params1.NOT_PRINT_TAIL)!=0);
        ((CheckBox)findViewById(R.id.par1_0002h)).setChecked((p1&TMCommand.doc_params1.NOT_SET_EMPTY_LINE)!=0);
        ((CheckBox)findViewById(R.id.par1_0004h)).setChecked((p1&TMCommand.doc_params1.NOT_PRINT_ZERO_COUNT)!=0);
        ((CheckBox)findViewById(R.id.par1_0008h)).setChecked((p1&TMCommand.doc_params1.RESERVED_0008)!=0);
        ((CheckBox)findViewById(R.id.par1_0010h)).setChecked((p1&TMCommand.doc_params1.PRINT_HEAD_BEFORE)!=0);
        ((CheckBox)findViewById(R.id.par1_0020h)).setChecked((p1&TMCommand.doc_params1.NOT_PRINT_RESOURCES)!=0);
        ((CheckBox)findViewById(R.id.par1_0040h)).setChecked((p1&TMCommand.doc_params1.NOT_PRINT_QTY_FOR_SINGLES)!=0);
        ((CheckBox)findViewById(R.id.par1_0080h)).setChecked((p1&TMCommand.doc_params1.NOT_REQUIRE_START_CMD)!=0);
        ((CheckBox)findViewById(R.id.par1_0100h)).setChecked((p1&TMCommand.doc_params1.RESERVED_0100)!=0);
        ((CheckBox)findViewById(R.id.par1_0200h)).setChecked((p1&TMCommand.doc_params1.RESERVED_0200)!=0);
        ((CheckBox)findViewById(R.id.par1_0400h)).setChecked((p1&TMCommand.doc_params1.RESERVED_0400)!=0);
        ((CheckBox)findViewById(R.id.par1_0800h)).setChecked((p1&TMCommand.doc_params1.RESERVED_0800)!=0);
        ((CheckBox)findViewById(R.id.par1_1000h)).setChecked((p1&TMCommand.doc_params1.RESERVED_1000)!=0);
        ((CheckBox)findViewById(R.id.par1_2000h)).setChecked((p1&TMCommand.doc_params1.PRINT_CLOSE_SHIFT)!=0);
        ((CheckBox)findViewById(R.id.par1_4000h)).setChecked((p1&TMCommand.doc_params1.RESERVED_4000)!=0);
        ((CheckBox)findViewById(R.id.par1_8000h)).setChecked((p1&TMCommand.doc_params1.PRINT_TAXES)!=0);

        //распарсивание параметра 2
        ((CheckBox)findViewById(R.id.par2_0001h)).setChecked((p2&TMCommand.doc_params2.AUTO_ENCASHMENT)!=0);
        ((CheckBox)findViewById(R.id.par2_0002h)).setChecked((p2&TMCommand.doc_params2.PRINT_GRAPH_HEADER)!=0);
        ((CheckBox)findViewById(R.id.par2_0004h)).setChecked((p2&TMCommand.doc_params2.RESERVED_0004)!=0);
        ((CheckBox)findViewById(R.id.par2_0008h)).setChecked((p2&TMCommand.doc_params2.RESERVED_0008)!=0);
        ((CheckBox)findViewById(R.id.par2_0010h)).setChecked((p2&TMCommand.doc_params2.NOT_PRINT_RUB)!=0);
        ((CheckBox)findViewById(R.id.par2_0020h)).setChecked((p2&TMCommand.doc_params2.NOT_CUT_TAPE)!=0);
        ((CheckBox)findViewById(R.id.par2_0040h)).setChecked((p2&TMCommand.doc_params2.PRINT_DISCOUNTS)!=0);
        ((CheckBox)findViewById(R.id.par2_0080h)).setChecked((p2&TMCommand.doc_params2.PRINT_UNIDOC_HEADER)!=0);
        ((CheckBox)findViewById(R.id.par2_0100h)).setChecked((p2&TMCommand.doc_params2.PRINT_DEPARTMENTS)!=0);
        ((CheckBox)findViewById(R.id.par2_0200h)).setChecked((p2&TMCommand.doc_params2.NARROW_CHEQUE)!=0);
        ((CheckBox)findViewById(R.id.par2_0400h)).setChecked((p2&TMCommand.doc_params2.RESERVED_0400)!=0);
        ((CheckBox)findViewById(R.id.par2_0800h)).setChecked((p2&TMCommand.doc_params2.PRINT_OPEN_SHIFT)!=0);
        ((CheckBox)findViewById(R.id.par2_1000h)).setChecked((p2&TMCommand.doc_params2.CRLF_DELIMIT_PARAM)!=0);
        ((CheckBox)findViewById(R.id.par2_2000h)).setChecked((p2&TMCommand.doc_params2.PRINT_DEP_QUANTITY)!=0);
        ((CheckBox)findViewById(R.id.par2_4000h)).setChecked((p2&TMCommand.doc_params2.WAIT_START_SYM)!=0);
        ((CheckBox)findViewById(R.id.par2_8000h)).setChecked((p2&TMCommand.doc_params2.RESERVED_8000)!=0);

        //распарсивание параметра 4 (дополнительные параметры)
        ((CheckBox)findViewById(R.id.par4_0001h)).setChecked((p4&TMCommand.doc_params4.RESERVED_0001)!=0);
        ((CheckBox)findViewById(R.id.par4_0002h)).setChecked((p4&TMCommand.doc_params4.DYNAMIC_POSITION_QR)!=0);
        ((CheckBox)findViewById(R.id.par4_0004h)).setChecked((p4&TMCommand.doc_params4.NOT_PRINT_READY_DOC)!=0);
        ((CheckBox)findViewById(R.id.par4_0008h)).setChecked((p4&TMCommand.doc_params4.COMBINE_IDENTICAL_ITEMS)!=0);
    }

    /* Хендлер для обработки сообщений от контроллера ФН. */
    class LibHandler extends TMLibHandler {

        /** Конструктор по умолчанию. */
        public LibHandler(){
            super(MainApp.GetCtx().getMainLooper());
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получение ответа на команду
            if ( cmd.GetMainError() == 0 ){
                //обработка успешных ответов
                switch((byte) cmd.GetCmdCode()) {
                    case TMCommand.commands.CM_SetParams:
                        //параметры установлены в контроллер ФН
                        MessageBox.Create(getString(R.string.header_success), getString(R.string.msg_cmd_success)+"\n\nПАРАМЕТРЫ СОХРАНЕНЫ В КОНТРОЛЛЕР ФН", MessageBox.option.OK).show(getSupportFragmentManager(), MessageBox.TAG);
                        isExit = true;
                        break;

                    case TMCommand.commands.CM_GetParams:
                        param1 = cmd.GetFieldHexW(5);
                        param2 = cmd.GetFieldHexW(6);
                        linefeed = cmd.GetFieldHexW(7);
                        param4 = cmd.GetFieldHexW(8);

                        //заполнение диалога
                        SetViewParse(param1, param2, linefeed, param4);
                        break;
                }
            }
            else {
                if ( cmd.GetCmdCode() == TMCommand.commands.CM_GetParams ) isExit = true;
                //сообщение об ошибке
                MessageBox.Create(getString(R.string.header_error), String.format(getString(R.string.msg_cmd_error),cmd.GetMainError(),cmd.GetSubError(),cmd.GetCmdCode())+"\n\n"+TMError.GetText((byte)cmd.GetMainError()), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
            }
        }

        @Override
        public void onTimeOut() {
            //сообщение о превышении таймаута обращения к контроллеру ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_timeout), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_service_fail)+"\n\n"+errText, MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }
    }
}
