package ru.nilsoft.example;

import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMError;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMLibHandler;

/**
 * Получение текущих счетчиков контроллера ФН.
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class CountersActivity extends AppCompatActivity {
    /** Handler для работы c контроллером ФН. */
    private Handler h;
    /** Уже выполнено. */
    private boolean isDone = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_counters);

        //создание хендлера
        h = new LibHandler();
    }

    @Override
    protected void onStart() {
        super.onStart();

        //регистрация хендлера для получения ответов от контроллера ФН
        TMLib.getInstance().registerHandler(h);

        if ( !isDone ) {
            isDone = true;
            FRGetDocCounters();
        }
    }

    @Override
    protected void onStop() {
        //освобождение хендлера
        TMLib.getInstance().unregisterHandler(h);

        super.onStop();
    }

    /** Обработка нажатия кнопки ОК. */
    public void onButtonOK(View view) {
        finish();
    }

    /**
     * Получение счетчиков документов.
     */
    private void FRGetDocCounters() {
        TMCommand cmd = new TMCommand();
        cmd.CmdGetDocCounters();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /**
     * Получение текущих счетчиков.
     */
    private void FRGetCurCounters() {
        TMCommand cmd = new TMCommand();
        cmd.CmdGetCurCounters();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /**
     * Получение статуса ФН.
     */
    private void FRFNGetStatus() {
        TMCommand cmd = new TMCommand();
        cmd.CmdFNGetStatus();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /* Хендлер для обработки сообщений от контроллера ФН. */
    class LibHandler extends TMLibHandler {

        /** Конструктор по умолчанию. */
        public LibHandler(){
            super(MainApp.GetCtx().getMainLooper());
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получение ответа на команду
            TextView viewText = findViewById(R.id.viewCounters);

            if ( cmd.GetMainError() != 0 ) {
                //сообщение об ошибке
                viewText.append("СБОЙ ВЫПОЛНЕНИЯ КОМАНДЫ: "+TMError.GetText((byte)cmd.GetMainError())+"\n");
            }
            else{
                switch( (byte)cmd.GetCmdCode() ) {
                    case TMCommand.commands.CM_GetDocCounters: {
                        //вывод счетчиков
                        String text = "СЧЕТЧИКИ ЗА СМЕНУ:\n" +
                                "Количество документов за смену: " + cmd.GetFieldHexW(5) + "\n" +
                                "Количество чеков за смену: " + cmd.GetFieldHexW(6) + "\n" +
                                "Количество аннулированных чеков за смену: " + cmd.GetFieldHexW(7) + "\n" +
                                "Количество п/документов за смену: " + cmd.GetFieldHexW(8) + "\n" +
                                "Количество анн.п/документов за смену: " + cmd.GetFieldHexW(9) + "\n" +
                                "Количество отчётных документов на чековой ленте за смену: " + cmd.GetFieldHexW(10) + "\n" +
                                "Количество универсальных п/док. за смену: " + cmd.GetFieldHexW(11) + "\n" +
                                "Количество чеков корреций за смену: " + cmd.GetFieldHexW(12) + "\n" +
                                "Количество приходов за смену: " + cmd.GetFieldHexW(13) + "\n" +
                                "Количество возвратов приходов за смену: " + cmd.GetFieldHexW(14) + "\n" +
                                "Количество расходов за смену: " + cmd.GetFieldHexW(15) + "\n" +
                                "Количество возвратов расходов за смену: " + cmd.GetFieldHexW(16) + "\n" +
                                "Количество коррекций прихода: " + cmd.GetFieldHexW(17) + "\n" +
                                "Количество коррекций расхода: " + cmd.GetFieldHexW(18) + "\n" +
                                "Количество подкреплений за смену: " + cmd.GetFieldHexW(19) + "\n" +
                                "Количество инкассаций за смену: " + cmd.GetFieldHexW(20);
                        viewText.setText(text);

                        //переход к следующей команде
                        FRGetCurCounters();
                        break;
                    }

                    case TMCommand.commands.CM_GetCurCounters: {
                        //вывод счетчиков
                        String text = "\n\nТЕКУЩИЕ СЧЕТЧИКИ:\n" +
                                "Сквозной номер последнего документа: " + cmd.GetFieldHexW(5) + "\n" +
                                "Номер последнего кассового чека: " + cmd.GetFieldHexW(6);
                        viewText.append(text);

                        //переход к следующей команде
                        FRFNGetStatus();
                        break;
                    }

                    case TMCommand.commands.CM_FNGetStatus: {
                        //вывод счетчиков
                        String text = "\n" +
                                "Номер последнего ФД: " + cmd.GetFieldHexDW(12) + "\n" +
                                "Номер смены: " + cmd.GetFieldHexW(16) + "\n" +
                                "Номер чека в смене: " + cmd.GetFieldHexW(17);
                        viewText.append(text);
                        break;
                    }
                }
            }
        }

        @Override
        public void onTimeOut() {
            //сообщение о превышении таймаута обращения к контроллеру ФН
            TextView viewText = findViewById(R.id.viewCounters);
            viewText.append("СБОЙ ВЫПОЛНЕНИЯ КОМАНДЫ: ПРЕВЫШЕН ТАЙМАУТ\n");
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            TextView viewText = findViewById(R.id.viewCounters);
            viewText.append("СБОЙ РАБОТЫ СЕРВИСА ВЗАИМОДЕЙСТВИЯ С КОНТРОЛЛЕРОМ: "+errText+"\n");
        }
    };
}
