package ru.nilsoft.example;

import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Handler;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMError;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMLibHandler;

/**
 * Закрытие смены на ККТ:
 * - ввод ФИО и ИНН кассира;
 * - закрытие смены на ККТ.
 *
 * @author <a href="http://www.nilsoft.ru">www.nilsoft.ru</a>, <a href="mailto:nilstarsoft@mail.ru">nilstarsoft@mail.ru</a>
 */
public class CloseShiftActivity extends AppCompatActivity implements MessageBox.CallBack{
    /** Handler для работы c TMLib. */
    private Handler h;
    /** Для однократного старта. */
    private boolean isStarted = false;
    /** Выход из диалога. */
    boolean isExit = false;

    /** Названия настроек для сохранения в файл настроек приложения. */
    public static final class sets{
        /** Имя пользователя. */
        static final String USER_NAME = "CloseShift_UserName";
        /** ИНН пользователя. */
        static final String USER_INN = "CloseShift_UserINN";
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_close_shift);

        //создание хендлера
        h = new LibHandler();
    }

    @Override
    protected void onStart() {
        super.onStart();

        //регистрация хендлера для получения ответов от контроллера ФН
        TMLib.getInstance().registerHandler(h);

        if ( !isStarted ) {
            isStarted = true;

            //заполнение данными (считываются из файла настроек приложения)
            ((TextView) findViewById(R.id.fio_kassir)).setText(MainApp.settings.getString(sets.USER_NAME, ""));
            ((TextView) findViewById(R.id.inn_kassir)).setText(MainApp.settings.getString(sets.USER_INN, ""));
        }
    }

    @Override
    protected void onStop() {
        //освобождение хендлера
        TMLib.getInstance().unregisterHandler(h);

        //сохранение данных (сохранение в файл настроек приложения)
        SharedPreferences.Editor editor = MainApp.settings.edit();
        editor.putString(sets.USER_NAME,String.valueOf(((TextView)findViewById(R.id.fio_kassir)).getText()));
        editor.putString(sets.USER_INN,String.valueOf(((TextView)findViewById(R.id.inn_kassir)).getText()));
        editor.apply();

        super.onStop();
    }

    /** При позитивном завершении диалога (нажатие кнопки ОК). */
    public void onMessageBoxPositiveClick(DialogInterface dialog) {
        //завершаем диалог
        if ( isExit ) finish();
    }

    /** При негативном завершении диалога (нажатие кнопки ОТМЕНА). */
    public void onMessageBoxNegativeClick(DialogInterface dialog) {
    }

    /** Обработка нажатия кнопки OK. */
    public void onButtonOK(View view) {
        //проверка введенных значений
        if ( String.valueOf(((TextView)findViewById(R.id.fio_kassir)).getText()).length() == 0 ) {
            MessageBox.Create(getString(R.string.header_warning), getString(R.string.msg_bad_field_cashier), MessageBox.option.OK).show(getSupportFragmentManager(), MessageBox.TAG);
        }
        else {
            //начинаем процедуру закрытия смены на ККТ:
            //сперва получаем время из контроллера (рекомендуется использовать время ККТ, так как Android время может измениться при пересечении поясов или синхронизации по сети).
            FRGetDateTime();
        }
    }

    /** Обработка нажатия кнопки ОТМЕНА. */
    public void onButtonCancel(View view) {
        finish(); //завершение диалога
    }

    /** Выполнение команды получения времени из КФН. */
    private void FRGetDateTime() {
        TMCommand cmd = new TMCommand();
        cmd.CmdGetDateTime();
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));
    }

    /**
     * Выполнение команды закрытия смены на ККТ.
     * @param tDate текущая дата.
     * @param tTime текущее время.
     * @param operName имя оператора.
     * @param operINN ИНН оператора.
     * @param notPrint true: не печатать чек, false: печатать.
     */
    private void FRShiftClose(String tDate, String tTime, String operName, String operINN, Boolean notPrint) {
        TMCommand cmd = new TMCommand();
        if ( ( tDate != null ) && ( tTime != null ) ) cmd.CmdShiftClose(tDate, tTime, operName, operINN, null, null, notPrint);
        else cmd.CmdShiftClose(operName, operINN, null, null, notPrint);
        TMLib.getInstance().DoCmd(this,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_PRINT_REPORT));
    }

    /** Хендлер для обработки сообщений от контроллера ФН. */
    class LibHandler extends TMLibHandler {

        /** Конструктор по умолчанию. */
        public LibHandler(){
            super(MainApp.GetCtx().getMainLooper());
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получен ответ на команду
            if ( cmd.GetMainError() != 0 ) {
                //сообщение об ошибке выполнения команды
                MessageBox.Create(getString(R.string.header_error), String.format(getString(R.string.msg_cmd_error), cmd.GetMainError(), cmd.GetSubError(), cmd.GetCmdCode()) + "\n\n" + TMError.GetText((byte) cmd.GetMainError()), MessageBox.option.OK | MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
            }
            else {
                switch((byte) cmd.GetCmdCode()) {
                    case TMCommand.commands.CM_GetDateTime:
                        //время получено, теперь выпполняем команду закрытия смены на ККТ
                        FRShiftClose(
                                cmd.GetFieldValue(5),
                                cmd.GetFieldValue(6),
                                String.valueOf(((TextView)findViewById(R.id.fio_kassir)).getText()),
                                String.valueOf(((TextView)findViewById(R.id.inn_kassir)).getText()),
                                ((CheckBox)findViewById(R.id.not_print)).isChecked());
                        break;

                    case TMCommand.commands.CM_ShiftClose:
                        //команда закрытия смены успешно выполнена
                        isExit = true;
                        //отправляем документ в ОФД (запускаем поток фоновой отправки, если он не запущен)
                        TMLib.getInstance().StartOFD();
                        //вывод диалога, что закрытие смены на ККТ прошло успешно
                        MessageBox.Create(getString(R.string.header_success), getString(R.string.msg_cmd_success)+"\n\nЗАБЕРИТЕ ЧЕК", MessageBox.option.OK).show(getSupportFragmentManager(), MessageBox.TAG);
                        break;
                }
            }
        }

        @Override
        public void onTimeOut() {
            //сообщение о превышении таймаута обращения к контроллеру ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_timeout), MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_service_fail)+"\n\n"+errText, MessageBox.option.OK|MessageBox.option.WARN).show(getSupportFragmentManager(), MessageBox.TAG);
        }
    };
}
