package ru.nilsoft.example;

import android.app.Dialog;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;

import ru.nilsoft.tm.TMCommand;
import ru.nilsoft.tm.TMLib;
import ru.nilsoft.tm.TMLibHandler;

public class CashBoxDialog extends DialogFragment {
    /** Тэг для диалога. */
    public final static String TAG = CashBoxDialog.class.getSimpleName();

    /** Результат команды. */
    public final static String RESULT_KEY = TAG+"result";

    /** Режим работы: false: внесение, true: инкасация. */
    private boolean mode;

    /**
     * Создание диалога.
     * @param mode false: внесение, true: инкасация.
     * @return диалог.
     */
    public static CashBoxDialog Create(boolean mode){
        CashBoxDialog dlg = new CashBoxDialog();
        dlg.mode = mode;
        return dlg;
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        //установка вида диалога
        final View dialogView = getLayoutInflater().inflate(R.layout.dialog_cash_box, null);

        //создаем AlertDialog
        AlertDialog.Builder mDialogBuilder = new AlertDialog.Builder(requireContext());

        ((EditText)dialogView.findViewById(R.id.input_cash_sum)).setText(CommonFunc.CURRENCY_ZERO);

        if ( savedInstanceState != null ) {
            //чтение сохраненных данных
            if (savedInstanceState.containsKey("mode")) mode = savedInstanceState.getBoolean("mode");
            if (savedInstanceState.containsKey("operSum")) ((EditText)dialogView.findViewById(R.id.input_cash_sum)).setText(savedInstanceState.getString("operSum"));
            if (savedInstanceState.containsKey("operFIO")) ((EditText)dialogView.findViewById(R.id.input_seller)).setText(savedInstanceState.getString("operFIO"));
        }

        //меняем строку в зависимости от режима
        ((TextView)dialogView.findViewById(R.id.text_cash_box_sum)).setText(mode?R.string.text_dlg_cash_box_sum_from:R.string.text_dlg_cash_box_sum_to);

        //настройка диалога
        mDialogBuilder
                .setView(dialogView)
                .setTitle(mode?getString(R.string.header_from_cash):getString(R.string.header_to_cash))
                .setPositiveButton(getString(R.string.btn_ok),
                        (dialog, id) -> {
                            try {
                                Bundle b = new Bundle();
                                saveToBundle(b);

                                //отправка ответа
                                getParentFragmentManager().setFragmentResult(RESULT_KEY,b);
                            }
                            catch(Exception ignored){}
                        })
                .setNegativeButton(getString(R.string.btn_cancel),
                        (dialog, id) -> dialog.cancel());

        //регистрация хендлера
        TMLib.getInstance().registerHandler(new LibHandler());

        //запуск команды получения суммы в ящике
        TMCommand cmd = new TMCommand();
        cmd.CmdGetMoney();
        TMLib.getInstance().DoCmd(null,cmd,CommonFunc.tmGetTimeOut(CommonFunc.tmTimeoutType.TM_TIMEOUT_CMD));

        return mDialogBuilder.create();
    }

    /**
     * Сохранение состояния в пакет.
     * @param b пакет.
     */
    private void saveToBundle(Bundle b) {
        try {
            b.putBoolean("mode", mode);
            b.putString("operSum", String.valueOf(((EditText) getDialog().findViewById(R.id.input_cash_sum)).getText()));
            b.putString("operFIO", String.valueOf(((EditText) getDialog().findViewById(R.id.input_seller)).getText()));
        }
        catch(Exception ignored) {}
    }

    /**
     * Для сохранения текста при повороте.
     * @param outState пакет.
     */
    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        //сохраненние данных
        saveToBundle(outState);

        super.onSaveInstanceState(outState);
    }

    /** Хендлер для обработки сообщений от контролера ФН. */
    private class LibHandler extends TMLibHandler {

        /** Конструктор по умолчанию. */
        public LibHandler(){
            super(MainApp.GetCtx().getMainLooper());
        }

        @Override
        public void onRespCmd(TMCommand cmd) {
            //получен ответ на команду
            switch((byte) cmd.GetCmdCode())
            {
                case TMCommand.commands.CM_GetMoney: {
                    //сумма в кассе
                    try {
                        TextView viewText = getDialog().findViewById(R.id.text_current_cash_sum);
                        if (cmd.GetMainError() != 0) {
                            //ошибка получения счетчиков сумм от ККТ
                            viewText.setText(getString(R.string.msg_unknown));
                        } else {
                            //вывод счетчиков сумм
                            viewText.setText(cmd.GetFieldValue(31));
                        }
                    }
                    catch (Exception ignored) {}
                }
                break;
            }
        }

        @Override
        public void onTimeOut() {
            //сообщение о превышении таймаута обращения к контроллеру ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_timeout), MessageBox.option.OK|MessageBox.option.WARN).show(getParentFragmentManager(), MessageBox.TAG);
        }

        @Override
        public void onError(String errText) {
            //сообщение о сбое сервиса взаимодействия с контроллером ФН
            MessageBox.Create(getString(R.string.header_error), getString(R.string.msg_service_fail)+"\n\n"+errText, MessageBox.option.OK|MessageBox.option.WARN).show(getParentFragmentManager(), MessageBox.TAG);
        }
    }
}
